/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Set;

public final class DecimalSaturatedFloorCasts {
    public static final SqlScalarFunction DECIMAL_TO_DECIMAL_SATURATED_FLOOR_CAST = SqlScalarFunction.builder(DecimalSaturatedFloorCasts.class).signature(Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.SATURATED_FLOOR_CAST).argumentTypes(TypeSignature.parseTypeSignature((String)"decimal(source_precision,source_scale)", (Set)ImmutableSet.of((Object)"source_precision", (Object)"source_scale"))).returnType(TypeSignature.parseTypeSignature((String)"decimal(result_precision,result_scale)", (Set)ImmutableSet.of((Object)"result_precision", (Object)"result_scale"))).build()).implementation(b -> b.methods("shortDecimalToShortDecimal", "shortDecimalToLongDecimal", "longDecimalToShortDecimal", "longDecimalToLongDecimal").withExtraParameters(context -> {
        int sourcePrecision = Ints.checkedCast((long)context.getLiteral("source_precision"));
        int sourceScale = Ints.checkedCast((long)context.getLiteral("source_scale"));
        int resultPrecision = Ints.checkedCast((long)context.getLiteral("result_precision"));
        int resultScale = Ints.checkedCast((long)context.getLiteral("result_scale"));
        return ImmutableList.of((Object)sourcePrecision, (Object)sourceScale, (Object)resultPrecision, (Object)resultScale);
    })).build();

    private DecimalSaturatedFloorCasts() {
    }

    @UsedByGeneratedCode
    public static long shortDecimalToShortDecimal(long value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.bigintToBigintFloorSaturatedCast(BigInteger.valueOf(value), sourceScale, resultPrecision, resultScale).longValueExact();
    }

    @UsedByGeneratedCode
    public static Slice shortDecimalToLongDecimal(long value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return Decimals.encodeUnscaledValue((BigInteger)DecimalSaturatedFloorCasts.bigintToBigintFloorSaturatedCast(BigInteger.valueOf(value), sourceScale, resultPrecision, resultScale));
    }

    @UsedByGeneratedCode
    public static long longDecimalToShortDecimal(Slice value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return DecimalSaturatedFloorCasts.bigintToBigintFloorSaturatedCast(Decimals.decodeUnscaledValue((Slice)value), sourceScale, resultPrecision, resultScale).longValueExact();
    }

    @UsedByGeneratedCode
    public static Slice longDecimalToLongDecimal(Slice value, int sourcePrecision, int sourceScale, int resultPrecision, int resultScale) {
        return Decimals.encodeUnscaledValue((BigInteger)DecimalSaturatedFloorCasts.bigintToBigintFloorSaturatedCast(Decimals.decodeUnscaledValue((Slice)value), sourceScale, resultPrecision, resultScale));
    }

    private static BigInteger bigintToBigintFloorSaturatedCast(BigInteger value, int sourceScale, int resultPrecision, int resultScale) {
        BigInteger maxUnscaledValue;
        BigDecimal bigDecimal = new BigDecimal(value, sourceScale);
        BigInteger unscaledValue = (bigDecimal = bigDecimal.setScale(resultScale, RoundingMode.FLOOR)).unscaledValue();
        if (unscaledValue.compareTo(maxUnscaledValue = Decimals.bigIntegerTenToNth((int)resultPrecision).subtract(BigInteger.ONE)) > 0) {
            return maxUnscaledValue;
        }
        BigInteger minUnscaledValue = maxUnscaledValue.negate();
        if (unscaledValue.compareTo(minUnscaledValue) < 0) {
            return minUnscaledValue;
        }
        return unscaledValue;
    }
}

