/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.SqlScalarFunctionBuilder;
import com.facebook.presto.operator.scalar.annotations.ScalarOperator;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.LiteralParameters;
import com.facebook.presto.type.SqlType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.XxHash64;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;

public final class DecimalOperators {
    public static final SqlScalarFunction DECIMAL_ADD_OPERATOR = DecimalOperators.decimalAddOperator();
    public static final SqlScalarFunction DECIMAL_SUBTRACT_OPERATOR = DecimalOperators.decimalSubtractOperator();
    public static final SqlScalarFunction DECIMAL_MULTIPLY_OPERATOR = DecimalOperators.decimalMultiplyOperator();
    public static final SqlScalarFunction DECIMAL_DIVIDE_OPERATOR = DecimalOperators.decimalDivideOperator();
    public static final SqlScalarFunction DECIMAL_MODULUS_OPERATOR = DecimalOperators.decimalModulusOperator();

    private DecimalOperators() {
    }

    private static SqlScalarFunction decimalAddOperator() {
        TypeSignature decimalLeftSignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalRightSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        TypeSignature decimalResultSignature = TypeSignature.parseTypeSignature((String)"decimal(r_precision, r_scale)", (Set)ImmutableSet.of((Object)"r_precision", (Object)"r_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.ADD).longVariableConstraints(Signature.longVariableExpression("r_precision", "min(38, max(a_precision - a_scale, b_precision - b_scale) + max(a_scale, b_scale) + 1)"), Signature.longVariableExpression("r_scale", "max(a_scale, b_scale)")).argumentTypes(decimalLeftSignature, decimalRightSignature).returnType(decimalResultSignature).build();
        return SqlScalarFunction.builder(DecimalOperators.class).signature(signature).implementation(b -> b.methods("addShortShortShort").withExtraParameters(DecimalOperators::shortRescaleExtraParameters)).implementation(b -> b.methods("addShortShortLong", "addLongLongLong", "addShortLongLong", "addLongShortLong").withExtraParameters(DecimalOperators::longRescaleExtraParameters)).build();
    }

    @UsedByGeneratedCode
    public static long addShortShortShort(long a, long b, long aRescale, long bRescale) {
        return a * aRescale + b * bRescale;
    }

    @UsedByGeneratedCode
    public static Slice addShortShortLong(long a, long b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = BigInteger.valueOf(a);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalAddLongLongLong(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static Slice addLongLongLong(Slice a, Slice b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalAddLongLongLong(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static Slice addShortLongLong(long a, Slice b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = BigInteger.valueOf(a);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalAddLongLongLong(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static Slice addLongShortLong(Slice a, long b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalAddLongLongLong(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    private static Slice internalAddLongLongLong(BigInteger aBigInteger, BigInteger bBigInteger, BigInteger aRescale, BigInteger bRescale) {
        BigInteger result = aBigInteger.multiply(aRescale).add(bBigInteger.multiply(bRescale));
        Decimals.checkOverflow((BigInteger)result);
        return Decimals.encodeUnscaledValue((BigInteger)result);
    }

    private static SqlScalarFunction decimalSubtractOperator() {
        TypeSignature decimalLeftSignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalRightSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        TypeSignature decimalResultSignature = TypeSignature.parseTypeSignature((String)"decimal(r_precision, r_scale)", (Set)ImmutableSet.of((Object)"r_precision", (Object)"r_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.SUBTRACT).longVariableConstraints(Signature.longVariableExpression("r_precision", "min(38, max(a_precision - a_scale, b_precision - b_scale) + max(a_scale, b_scale) + 1)"), Signature.longVariableExpression("r_scale", "max(a_scale, b_scale)")).argumentTypes(decimalLeftSignature, decimalRightSignature).returnType(decimalResultSignature).build();
        return SqlScalarFunction.builder(DecimalOperators.class).signature(signature).implementation(b -> b.methods("subtractShortShortShort").withExtraParameters(DecimalOperators::shortRescaleExtraParameters)).implementation(b -> b.methods("subtractShortShortLong", "subtractLongLongLong", "subtractShortLongLong", "subtractLongShortLong").withExtraParameters(DecimalOperators::longRescaleExtraParameters)).build();
    }

    @UsedByGeneratedCode
    public static long subtractShortShortShort(long a, long b, long aRescale, long bRescale) {
        return a * aRescale - b * bRescale;
    }

    @UsedByGeneratedCode
    public static Slice subtractShortShortLong(long a, long b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = BigInteger.valueOf(a);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalSubtractLongLongLong(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static Slice subtractLongLongLong(Slice a, Slice b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalSubtractLongLongLong(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static Slice subtractShortLongLong(long a, Slice b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = BigInteger.valueOf(a);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalSubtractLongLongLong(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static Slice subtractLongShortLong(Slice a, long b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalSubtractLongLongLong(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    private static Slice internalSubtractLongLongLong(BigInteger aBigInteger, BigInteger bBigInteger, BigInteger aRescale, BigInteger bRescale) {
        BigInteger result = aBigInteger.multiply(aRescale).subtract(bBigInteger.multiply(bRescale));
        Decimals.checkOverflow((BigInteger)result);
        return Decimals.encodeUnscaledValue((BigInteger)result);
    }

    private static SqlScalarFunction decimalMultiplyOperator() {
        TypeSignature decimalLeftSignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalRightSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        TypeSignature decimalResultSignature = TypeSignature.parseTypeSignature((String)"decimal(r_precision, r_scale)", (Set)ImmutableSet.of((Object)"r_precision", (Object)"r_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.MULTIPLY).longVariableConstraints(Signature.longVariableExpression("r_precision", "min(38, a_precision + b_precision)"), Signature.longVariableExpression("r_scale", "a_scale + b_scale")).argumentTypes(decimalLeftSignature, decimalRightSignature).returnType(decimalResultSignature).build();
        return SqlScalarFunction.builder(DecimalOperators.class).signature(signature).implementation(b -> b.methods("multiplyShortShortShort", "multiplyShortShortLong", "multiplyLongLongLong", "multiplyShortLongLong", "multiplyLongShortLong")).build();
    }

    @UsedByGeneratedCode
    public static long multiplyShortShortShort(long a, long b) {
        return a * b;
    }

    @UsedByGeneratedCode
    public static Slice multiplyShortShortLong(long a, long b) {
        BigInteger aBigInteger = BigInteger.valueOf(a);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalMultiplyLongLongLong(aBigInteger, bBigInteger);
    }

    @UsedByGeneratedCode
    public static Slice multiplyLongLongLong(Slice a, Slice b) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalMultiplyLongLongLong(aBigInteger, bBigInteger);
    }

    @UsedByGeneratedCode
    public static Slice multiplyShortLongLong(long a, Slice b) {
        BigInteger aBigInteger = BigInteger.valueOf(a);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalMultiplyLongLongLong(aBigInteger, bBigInteger);
    }

    @UsedByGeneratedCode
    public static Slice multiplyLongShortLong(Slice a, long b) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalMultiplyLongLongLong(aBigInteger, bBigInteger);
    }

    private static Slice internalMultiplyLongLongLong(BigInteger aBigInteger, BigInteger bBigInteger) {
        BigInteger result = aBigInteger.multiply(bBigInteger);
        Decimals.checkOverflow((BigInteger)result);
        return Decimals.encodeUnscaledValue((BigInteger)result);
    }

    private static SqlScalarFunction decimalDivideOperator() {
        TypeSignature decimalLeftSignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalRightSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        TypeSignature decimalResultSignature = TypeSignature.parseTypeSignature((String)"decimal(r_precision, r_scale)", (Set)ImmutableSet.of((Object)"r_precision", (Object)"r_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.DIVIDE).longVariableConstraints(Signature.longVariableExpression("r_precision", "min(38, a_precision + b_scale + max(b_scale - a_scale, 0))"), Signature.longVariableExpression("r_scale", "max(a_scale, b_scale)")).argumentTypes(decimalLeftSignature, decimalRightSignature).returnType(decimalResultSignature).build();
        return SqlScalarFunction.builder(DecimalOperators.class).signature(signature).implementation(b -> b.methods("divideShortShortShort").withExtraParameters(DecimalOperators::shortDivideRescaleExtraParameter)).implementation(b -> b.methods("divideShortLongShort", "divideLongShortShort", "divideShortShortLong", "divideLongLongLong", "divideShortLongLong", "divideLongShortLong").withExtraParameters(DecimalOperators::longDivideRescaleExtraParameter)).build();
    }

    private static List<Object> shortDivideRescaleExtraParameter(SqlScalarFunctionBuilder.SpecializeContext context) {
        int rescaleFactor = DecimalOperators.divideRescaleFactor(context);
        return ImmutableList.of((Object)Decimals.longTenToNth((int)rescaleFactor));
    }

    private static List<Object> longDivideRescaleExtraParameter(SqlScalarFunctionBuilder.SpecializeContext context) {
        int rescaleFactor = DecimalOperators.divideRescaleFactor(context);
        return ImmutableList.of((Object)Decimals.bigIntegerTenToNth((int)rescaleFactor));
    }

    private static int divideRescaleFactor(SqlScalarFunctionBuilder.SpecializeContext context) {
        DecimalType returnType = (DecimalType)context.getReturnType();
        return (int)((long)returnType.getScale() - context.getLiteral("a_scale") + context.getLiteral("b_scale") + 1L);
    }

    @UsedByGeneratedCode
    public static long divideShortShortShort(long a, long b, long aRescale) {
        try {
            long result = a * aRescale / b;
            if (result > 0L) {
                if (result % 10L >= 5L) {
                    return result / 10L + 1L;
                }
                return result / 10L;
            }
            if (result % 10L <= -5L) {
                return result / 10L - 1L;
            }
            return result / 10L;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static long divideShortLongShort(long a, Slice b, BigInteger aRescale) {
        BigInteger aBigInteger = BigInteger.valueOf(a);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalDivideShortResult(aBigInteger, bBigInteger, aRescale);
    }

    @UsedByGeneratedCode
    public static long divideLongShortShort(Slice a, long b, BigInteger aRescale) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalDivideShortResult(aBigInteger, bBigInteger, aRescale);
    }

    private static long internalDivideShortResult(BigInteger aBigInteger, BigInteger bBigInteger, BigInteger aRescale) {
        try {
            return DecimalOperators.internalDivideDecimals(aBigInteger.multiply(aRescale), bBigInteger).longValue();
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @UsedByGeneratedCode
    public static Slice divideShortShortLong(long a, long b, BigInteger aRescale) {
        BigInteger aBigInteger = BigInteger.valueOf(a).multiply(aRescale);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalDivideLongLongLong(aBigInteger, bBigInteger);
    }

    @UsedByGeneratedCode
    public static Slice divideLongLongLong(Slice a, Slice b, BigInteger aRescale) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a).multiply(aRescale);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalDivideLongLongLong(aBigInteger, bBigInteger);
    }

    @UsedByGeneratedCode
    public static Slice divideShortLongLong(long a, Slice b, BigInteger aRescale) {
        BigInteger aBigInteger = BigInteger.valueOf(a).multiply(aRescale);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalDivideLongLongLong(aBigInteger, bBigInteger);
    }

    @UsedByGeneratedCode
    public static Slice divideLongShortLong(Slice a, long b, BigInteger aRescale) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a).multiply(aRescale);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalDivideLongLongLong(aBigInteger, bBigInteger);
    }

    private static Slice internalDivideLongLongLong(BigInteger aBigInteger, BigInteger bBigInteger) {
        try {
            BigInteger result = aBigInteger.divide(bBigInteger);
            BigInteger resultModTen = result.mod(BigInteger.TEN);
            result = result.signum() > 0 ? (resultModTen.compareTo(BigInteger.valueOf(5L)) >= 0 ? result.divide(BigInteger.TEN).add(BigInteger.ONE) : result.divide(BigInteger.TEN)) : (resultModTen.compareTo(BigInteger.valueOf(5L)) < 0 && !resultModTen.equals(BigInteger.ZERO) ? result.divide(BigInteger.TEN).subtract(BigInteger.ONE) : result.divide(BigInteger.TEN));
            Decimals.checkOverflow((BigInteger)result);
            return Decimals.encodeUnscaledValue((BigInteger)result);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    private static BigInteger internalDivideDecimals(BigInteger aBigInteger, BigInteger bBigInteger) {
        BigInteger result = aBigInteger.divide(bBigInteger);
        BigInteger resultModTen = result.mod(BigInteger.TEN);
        result = result.signum() > 0 ? (resultModTen.compareTo(BigInteger.valueOf(5L)) >= 0 ? result.divide(BigInteger.TEN).add(BigInteger.ONE) : result.divide(BigInteger.TEN)) : (resultModTen.compareTo(BigInteger.valueOf(5L)) < 0 && !resultModTen.equals(BigInteger.ZERO) ? result.divide(BigInteger.TEN).subtract(BigInteger.ONE) : result.divide(BigInteger.TEN));
        Decimals.checkOverflow((BigInteger)result);
        return result;
    }

    private static SqlScalarFunction decimalModulusOperator() {
        TypeSignature decimalLeftSignature = TypeSignature.parseTypeSignature((String)"decimal(a_precision, a_scale)", (Set)ImmutableSet.of((Object)"a_precision", (Object)"a_scale"));
        TypeSignature decimalRightSignature = TypeSignature.parseTypeSignature((String)"decimal(b_precision, b_scale)", (Set)ImmutableSet.of((Object)"b_precision", (Object)"b_scale"));
        TypeSignature decimalResultSignature = TypeSignature.parseTypeSignature((String)"decimal(r_precision, r_scale)", (Set)ImmutableSet.of((Object)"r_precision", (Object)"r_scale"));
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.MODULUS).longVariableConstraints(Signature.longVariableExpression("r_precision", "min(b_precision - b_scale, a_precision - a_scale) + max(a_scale, b_scale)"), Signature.longVariableExpression("r_scale", "max(a_scale, b_scale)")).argumentTypes(decimalLeftSignature, decimalRightSignature).returnType(decimalResultSignature).build();
        return SqlScalarFunction.builder(DecimalOperators.class).signature(signature).implementation(b -> b.methods("modulusShortShortShort", "modulusLongLongLong", "modulusShortLongLong", "modulusShortLongShort", "modulusLongShortShort", "modulusLongShortLong").withExtraParameters(DecimalOperators::longRescaleExtraParameters)).build();
    }

    private static List<Object> shortRescaleExtraParameters(SqlScalarFunctionBuilder.SpecializeContext context) {
        long aRescale = Decimals.longTenToNth((int)DecimalOperators.rescaleFactor(context.getLiteral("a_scale"), context.getLiteral("b_scale")));
        long bRescale = Decimals.longTenToNth((int)DecimalOperators.rescaleFactor(context.getLiteral("b_scale"), context.getLiteral("a_scale")));
        return ImmutableList.of((Object)aRescale, (Object)bRescale);
    }

    private static List<Object> longRescaleExtraParameters(SqlScalarFunctionBuilder.SpecializeContext context) {
        BigInteger aRescale = Decimals.bigIntegerTenToNth((int)DecimalOperators.rescaleFactor(context.getLiteral("a_scale"), context.getLiteral("b_scale")));
        BigInteger bRescale = Decimals.bigIntegerTenToNth((int)DecimalOperators.rescaleFactor(context.getLiteral("b_scale"), context.getLiteral("a_scale")));
        return ImmutableList.of((Object)aRescale, (Object)bRescale);
    }

    private static int rescaleFactor(long fromScale, long toScale) {
        return Integer.max(0, (int)toScale - (int)fromScale);
    }

    @UsedByGeneratedCode
    public static long modulusShortShortShort(long a, long b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = BigInteger.valueOf(a);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalModulusShortResult(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static Slice modulusLongLongLong(Slice a, Slice b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalModulusLongResult(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static Slice modulusShortLongLong(long a, Slice b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = BigInteger.valueOf(a);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b);
        return DecimalOperators.internalModulusLongResult(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static long modulusShortLongShort(long a, Slice b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = BigInteger.valueOf(a).multiply(aRescale);
        BigInteger bBigInteger = Decimals.decodeUnscaledValue((Slice)b).multiply(bRescale);
        return DecimalOperators.internalModulusShortResult(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static long modulusLongShortShort(Slice a, long b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalModulusShortResult(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    @UsedByGeneratedCode
    public static Slice modulusLongShortLong(Slice a, long b, BigInteger aRescale, BigInteger bRescale) {
        BigInteger aBigInteger = Decimals.decodeUnscaledValue((Slice)a);
        BigInteger bBigInteger = BigInteger.valueOf(b);
        return DecimalOperators.internalModulusLongResult(aBigInteger, bBigInteger, aRescale, bRescale);
    }

    private static long internalModulusShortResult(BigInteger aBigInteger, BigInteger bBigInteger, BigInteger aRescale, BigInteger bRescale) {
        try {
            return aBigInteger.multiply(aRescale).remainder(bBigInteger.multiply(bRescale)).longValue();
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    private static Slice internalModulusLongResult(BigInteger aBigInteger, BigInteger bBigInteger, BigInteger aRescale, BigInteger bRescale) {
        try {
            BigInteger result = aBigInteger.multiply(aRescale).remainder(bBigInteger.multiply(bRescale));
            return Decimals.encodeUnscaledValue((BigInteger)result);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DIVISION_BY_ZERO, (Throwable)e);
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    public static final class HashCode {
        @LiteralParameters(value={"p", "s"})
        @SqlType(value="bigint")
        public static long hashCode(@SqlType(value="decimal(p, s)") long value) {
            return value;
        }

        @LiteralParameters(value={"p", "s"})
        @SqlType(value="bigint")
        public static long hashCode(@SqlType(value="decimal(p, s)") Slice value) {
            return XxHash64.hash((Slice)value);
        }
    }

    @ScalarOperator(value=OperatorType.NEGATION)
    public static final class Negation {
        @LiteralParameters(value={"p", "s"})
        @SqlType(value="decimal(p, s)")
        public static long negate(@SqlType(value="decimal(p, s)") long arg) {
            return -arg;
        }

        @LiteralParameters(value={"p", "s"})
        @SqlType(value="decimal(p, s)")
        public static Slice negate(@SqlType(value="decimal(p, s)") Slice arg) {
            BigInteger argBigInteger = Decimals.decodeUnscaledValue((Slice)arg);
            return Decimals.encodeUnscaledValue((BigInteger)argBigInteger.negate());
        }
    }
}

