/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.SqlScalarFunctionBuilder;
import com.facebook.presto.operator.scalar.JsonOperators;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Types;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Shorts;
import com.google.common.primitives.SignedBytes;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import javax.annotation.Nullable;

public final class DecimalCasts {
    public static final SqlScalarFunction DECIMAL_TO_BOOLEAN_CAST = DecimalCasts.castFunctionFromDecimalTo("boolean", "shortDecimalToBoolean", "longDecimalToBoolean");
    public static final SqlScalarFunction BOOLEAN_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom("boolean", "booleanToShortDecimal", "booleanToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_BIGINT_CAST = DecimalCasts.castFunctionFromDecimalTo("bigint", "shortDecimalToBigint", "longDecimalToBigint");
    public static final SqlScalarFunction BIGINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom("bigint", "bigintToShortDecimal", "bigintToLongDecimal");
    public static final SqlScalarFunction INTEGER_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom("integer", "integerToShortDecimal", "integerToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_INTEGER_CAST = DecimalCasts.castFunctionFromDecimalTo("integer", "shortDecimalToInteger", "longDecimalToInteger");
    public static final SqlScalarFunction SMALLINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom("smallint", "smallintToShortDecimal", "smallintToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_SMALLINT_CAST = DecimalCasts.castFunctionFromDecimalTo("smallint", "shortDecimalToSmallint", "longDecimalToSmallint");
    public static final SqlScalarFunction TINYINT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom("tinyint", "tinyintToShortDecimal", "tinyintToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_TINYINT_CAST = DecimalCasts.castFunctionFromDecimalTo("tinyint", "shortDecimalToTinyint", "longDecimalToTinyint");
    public static final SqlScalarFunction DECIMAL_TO_DOUBLE_CAST = DecimalCasts.castFunctionFromDecimalTo("double", "shortDecimalToDouble", "longDecimalToDouble");
    public static final SqlScalarFunction DOUBLE_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom("double", "doubleToShortDecimal", "doubleToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_FLOAT_CAST = DecimalCasts.castFunctionFromDecimalTo("float", "shortDecimalToFloat", "longDecimalToFloat");
    public static final SqlScalarFunction FLOAT_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom("float", "floatToShortDecimal", "floatToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_VARCHAR_CAST = DecimalCasts.castFunctionFromDecimalTo("varchar", "shortDecimalToVarchar", "longDecimalToVarchar");
    public static final SqlScalarFunction VARCHAR_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFrom("varchar", "varcharToShortDecimal", "varcharToLongDecimal");
    public static final SqlScalarFunction DECIMAL_TO_JSON_CAST = DecimalCasts.castFunctionFromDecimalTo("json", "shortDecimalToJson", "longDecimalToJson");
    public static final SqlScalarFunction JSON_TO_DECIMAL_CAST = DecimalCasts.castFunctionToDecimalFromBuilder("json", "jsonToShortDecimal", "jsonToLongDecimal").nullableResult(true).build();

    private static SqlScalarFunction castFunctionFromDecimalTo(String to, String ... methodNames) {
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.CAST).argumentTypes(TypeSignature.parseTypeSignature((String)"decimal(precision,scale)", (Set)ImmutableSet.of((Object)"precision", (Object)"scale"))).returnType(TypeSignature.parseTypeSignature((String)to, (Set)ImmutableSet.of((Object)"x", (Object)"precision", (Object)"scale"))).build();
        return SqlScalarFunction.builder(DecimalCasts.class).signature(signature).implementation(b -> b.methods(methodNames).withExtraParameters(context -> {
            long precision = context.getLiteral("precision");
            long scale = context.getLiteral("scale");
            long tenToScale = Decimals.longTenToNth((int)((int)scale));
            return ImmutableList.of((Object)precision, (Object)scale, (Object)tenToScale);
        })).build();
    }

    private static SqlScalarFunction castFunctionToDecimalFrom(String from, String ... methodNames) {
        return DecimalCasts.castFunctionToDecimalFromBuilder(from, methodNames).build();
    }

    private static SqlScalarFunctionBuilder castFunctionToDecimalFromBuilder(String from, String ... methodNames) {
        Signature signature = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.CAST).typeVariableConstraints(Signature.withVariadicBound("X", "decimal")).argumentTypes(TypeSignature.parseTypeSignature((String)from)).returnType(TypeSignature.parseTypeSignature((String)"X")).build();
        return SqlScalarFunction.builder(DecimalCasts.class).signature(signature).implementation(b -> b.methods(methodNames).withExtraParameters(context -> {
            DecimalType resultType = Types.checkType(context.getReturnType(), DecimalType.class, "resultType");
            long tenToScale = Decimals.longTenToNth((int)resultType.getScale());
            return ImmutableList.of((Object)resultType.getPrecision(), (Object)resultType.getScale(), (Object)tenToScale);
        }));
    }

    private DecimalCasts() {
    }

    @UsedByGeneratedCode
    public static boolean shortDecimalToBoolean(long decimal, long precision, long scale, long tenToScale) {
        return decimal != 0L;
    }

    @UsedByGeneratedCode
    public static boolean longDecimalToBoolean(Slice decimal, long precision, long scale, long tenToScale) {
        return !Decimals.decodeUnscaledValue((Slice)decimal).equals(BigInteger.ZERO);
    }

    @UsedByGeneratedCode
    public static long booleanToShortDecimal(boolean value, long precision, long scale, long tenToScale) {
        return value ? tenToScale : 0L;
    }

    @UsedByGeneratedCode
    public static Slice booleanToLongDecimal(boolean value, long precision, long scale, long tenToScale) {
        return Decimals.encodeUnscaledValue((BigInteger)BigInteger.valueOf(value ? tenToScale : 0L));
    }

    @UsedByGeneratedCode
    public static long shortDecimalToBigint(long decimal, long precision, long scale, long tenToScale) {
        if (decimal >= 0L) {
            return (decimal + tenToScale / 2L) / tenToScale;
        }
        return -((-decimal + tenToScale / 2L) / tenToScale);
    }

    @UsedByGeneratedCode
    public static long longDecimalToBigint(Slice decimal, long precision, long scale, long tenToScale) {
        BigDecimal bigDecimal = new BigDecimal(Decimals.decodeUnscaledValue((Slice)decimal), (int)scale);
        bigDecimal = bigDecimal.setScale(0, RoundingMode.HALF_UP);
        try {
            return bigDecimal.longValueExact();
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to BIGINT", bigDecimal));
        }
    }

    @UsedByGeneratedCode
    public static long bigintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)((int)precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice bigintToLongDecimal(long value, long precision, long scale, long tenToScale) {
        BigInteger decimalBigInteger = BigInteger.valueOf(value).multiply(BigInteger.valueOf(tenToScale));
        if (Decimals.overflows((BigInteger)decimalBigInteger, (int)((int)precision))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast BIGINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
        return Decimals.encodeUnscaledValue((BigInteger)decimalBigInteger);
    }

    @UsedByGeneratedCode
    public static long shortDecimalToInteger(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return Math.toIntExact(longResult);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to INTEGER", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToInteger(Slice decimal, long precision, long scale, long tenToScale) {
        BigDecimal bigDecimal = new BigDecimal(Decimals.decodeUnscaledValue((Slice)decimal), (int)scale);
        bigDecimal = bigDecimal.setScale(0, RoundingMode.HALF_UP);
        try {
            return bigDecimal.intValueExact();
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to INTEGER", bigDecimal));
        }
    }

    @UsedByGeneratedCode
    public static long integerToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)((int)precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice integerToLongDecimal(long value, long precision, long scale, long tenToScale) {
        BigInteger decimalBigInteger = BigInteger.valueOf(value).multiply(BigInteger.valueOf(tenToScale));
        if (Decimals.overflows((BigInteger)decimalBigInteger, (int)((int)precision))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast INTEGER '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
        return Decimals.encodeUnscaledValue((BigInteger)decimalBigInteger);
    }

    @UsedByGeneratedCode
    public static long shortDecimalToSmallint(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return Shorts.checkedCast((long)longResult);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to SMALLINT", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToSmallint(Slice decimal, long precision, long scale, long tenToScale) {
        BigDecimal bigDecimal = new BigDecimal(Decimals.decodeUnscaledValue((Slice)decimal), (int)scale);
        bigDecimal = bigDecimal.setScale(0, RoundingMode.HALF_UP);
        try {
            return bigDecimal.shortValueExact();
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to SMALLINT", bigDecimal));
        }
    }

    @UsedByGeneratedCode
    public static long smallintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)((int)precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice smallintToLongDecimal(long value, long precision, long scale, long tenToScale) {
        BigInteger decimalBigInteger = BigInteger.valueOf(value).multiply(BigInteger.valueOf(tenToScale));
        if (Decimals.overflows((BigInteger)decimalBigInteger, (int)((int)precision))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast SMALLINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
        return Decimals.encodeUnscaledValue((BigInteger)decimalBigInteger);
    }

    @UsedByGeneratedCode
    public static long shortDecimalToTinyint(long decimal, long precision, long scale, long tenToScale) {
        long longResult = (decimal + tenToScale / 2L) / tenToScale;
        if (decimal < 0L) {
            longResult = -((-decimal + tenToScale / 2L) / tenToScale);
        }
        try {
            return SignedBytes.checkedCast((long)longResult);
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to TINYINT", longResult));
        }
    }

    @UsedByGeneratedCode
    public static long longDecimalToTinyint(Slice decimal, long precision, long scale, long tenToScale) {
        BigDecimal bigDecimal = new BigDecimal(Decimals.decodeUnscaledValue((Slice)decimal), (int)scale);
        bigDecimal = bigDecimal.setScale(0, RoundingMode.HALF_UP);
        try {
            return bigDecimal.byteValueExact();
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to TINYINT", bigDecimal));
        }
    }

    @UsedByGeneratedCode
    public static long tinyintToShortDecimal(long value, long precision, long scale, long tenToScale) {
        try {
            long decimal = Math.multiplyExact(value, tenToScale);
            if (Decimals.overflows((long)decimal, (int)((int)precision))) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
            }
            return decimal;
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice tinyintToLongDecimal(long value, long precision, long scale, long tenToScale) {
        BigInteger decimalBigInteger = BigInteger.valueOf(value).multiply(BigInteger.valueOf(tenToScale));
        if (Decimals.overflows((BigInteger)decimalBigInteger, (int)((int)precision))) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast TINYINT '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
        return Decimals.encodeUnscaledValue((BigInteger)decimalBigInteger);
    }

    @UsedByGeneratedCode
    public static double shortDecimalToDouble(long decimal, long precision, long scale, long tenToScale) {
        return (double)decimal / (double)tenToScale;
    }

    @UsedByGeneratedCode
    public static double longDecimalToDouble(Slice decimal, long precision, long scale, long tenToScale) {
        BigInteger decimalBigInteger = Decimals.decodeUnscaledValue((Slice)decimal);
        BigDecimal bigDecimal = new BigDecimal(decimalBigInteger, (int)scale);
        return bigDecimal.doubleValue();
    }

    @UsedByGeneratedCode
    public static long shortDecimalToFloat(long decimal, long precision, long scale, long tenToScale) {
        return Float.floatToRawIntBits((float)decimal / (float)tenToScale);
    }

    @UsedByGeneratedCode
    public static long longDecimalToFloat(Slice decimal, long precision, long scale, long tenToScale) {
        BigInteger decimalBigInteger = Decimals.decodeUnscaledValue((Slice)decimal);
        BigDecimal bigDecimal = new BigDecimal(decimalBigInteger, (int)scale);
        return Float.floatToRawIntBits(bigDecimal.floatValue());
    }

    @UsedByGeneratedCode
    public static long doubleToShortDecimal(double value, long precision, long scale, long tenToScale) {
        BigDecimal decimal = new BigDecimal(value);
        if (Decimals.overflows((BigDecimal)(decimal = decimal.setScale((int)scale, 4)), (long)precision)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DOUBLE '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
        return decimal.unscaledValue().longValue();
    }

    @UsedByGeneratedCode
    public static Slice doubleToLongDecimal(double value, long precision, long scale, long tenToScale) {
        BigDecimal decimal = new BigDecimal(value);
        if (Decimals.overflows((BigDecimal)(decimal = decimal.setScale((int)scale, 4)), (long)precision)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DOUBLE '%s' to DECIMAL(%s, %s)", value, precision, scale));
        }
        BigInteger decimalBigInteger = decimal.unscaledValue();
        return Decimals.encodeUnscaledValue((BigInteger)decimalBigInteger);
    }

    @UsedByGeneratedCode
    public static long floatToShortDecimal(long value, long precision, long scale, long tenToScale) {
        BigDecimal decimal = new BigDecimal(Float.intBitsToFloat((int)value));
        if (Decimals.overflows((BigDecimal)(decimal = decimal.setScale((int)scale, 4)), (long)precision)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast FLOAT '%s' to DECIMAL(%s, %s)", Float.valueOf(Float.intBitsToFloat((int)value)), precision, scale));
        }
        return decimal.unscaledValue().longValue();
    }

    @UsedByGeneratedCode
    public static Slice floatToLongDecimal(long value, long precision, long scale, long tenToScale) {
        BigDecimal decimal = new BigDecimal(Float.intBitsToFloat((int)value));
        if (Decimals.overflows((BigDecimal)(decimal = decimal.setScale((int)scale, 4)), (long)precision)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast FLOAT '%s' to DECIMAL(%s, %s)", Float.valueOf(Float.intBitsToFloat((int)value)), precision, scale));
        }
        BigInteger decimalBigInteger = decimal.unscaledValue();
        return Decimals.encodeUnscaledValue((BigInteger)decimalBigInteger);
    }

    @UsedByGeneratedCode
    public static Slice shortDecimalToVarchar(long decimal, long precision, long scale, long tenToScale) {
        return Slices.copiedBuffer((String)Decimals.toString((long)decimal, (int)((int)scale)), (Charset)StandardCharsets.UTF_8);
    }

    @UsedByGeneratedCode
    public static Slice longDecimalToVarchar(Slice decimal, long precision, long scale, long tenToScale) {
        return Slices.copiedBuffer((String)Decimals.toString((Slice)decimal, (int)((int)scale)), (Charset)StandardCharsets.UTF_8);
    }

    @UsedByGeneratedCode
    public static long varcharToShortDecimal(Slice value, long precision, long scale, long tenToScale) {
        try {
            String stringValue = value.toString(StandardCharsets.UTF_8);
            BigDecimal decimal = new BigDecimal(stringValue).setScale((int)scale, 4);
            if (Decimals.overflows((BigDecimal)decimal, (long)precision)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s)", stringValue, precision, scale));
            }
            return decimal.unscaledValue().longValue();
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s)", value.toString(StandardCharsets.UTF_8), precision, scale));
        }
    }

    @UsedByGeneratedCode
    public static Slice varcharToLongDecimal(Slice value, long precision, long scale, long tenToScale) {
        String stringValue = value.toString(StandardCharsets.UTF_8);
        BigDecimal decimal = new BigDecimal(stringValue).setScale((int)scale, 4);
        if (Decimals.overflows((BigDecimal)decimal, (long)precision)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast VARCHAR '%s' to DECIMAL(%s, %s)", stringValue, precision, scale));
        }
        return Decimals.encodeUnscaledValue((BigInteger)decimal.unscaledValue());
    }

    @UsedByGeneratedCode
    public static Slice shortDecimalToJson(long decimal, long precision, long scale, long tenToScale) throws IOException {
        return DecimalCasts.decimalToJson(BigDecimal.valueOf(decimal, (int)scale));
    }

    @UsedByGeneratedCode
    public static Slice longDecimalToJson(Slice decimal, long precision, long scale, long tenToScale) throws IOException {
        return DecimalCasts.decimalToJson(new BigDecimal(Decimals.decodeUnscaledValue((Slice)decimal), Ints.checkedCast((long)scale)));
    }

    private static Slice decimalToJson(BigDecimal bigDecimal) {
        try {
            DynamicSliceOutput dynamicSliceOutput = new DynamicSliceOutput(32);
            try (JsonGenerator jsonGenerator = JsonOperators.JSON_FACTORY.createGenerator((OutputStream)dynamicSliceOutput);){
                jsonGenerator.writeNumber(bigDecimal);
            }
            return dynamicSliceOutput.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%f' to %s", bigDecimal, "json"));
        }
    }

    @UsedByGeneratedCode
    public static Slice jsonToLongDecimal(Slice json, long precision, long scale, long tenToScale) throws IOException {
        BigDecimal bigDecimal = DecimalCasts.jsonToDecimal(json, precision, scale);
        if (bigDecimal == null) {
            return null;
        }
        return Decimals.encodeUnscaledValue((BigInteger)bigDecimal.unscaledValue());
    }

    @UsedByGeneratedCode
    public static Long jsonToShortDecimal(Slice json, long precision, long scale, long tenToScale) throws IOException {
        BigDecimal bigDecimal = DecimalCasts.jsonToDecimal(json, precision, scale);
        return bigDecimal != null ? Long.valueOf(bigDecimal.unscaledValue().longValue()) : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static BigDecimal jsonToDecimal(Slice json, long precision, long scale) {
        try (JsonParser parser = JsonOperators.JSON_FACTORY.createParser((InputStream)json.getInput());){
            BigDecimal result;
            parser.nextToken();
            switch (parser.getCurrentToken()) {
                case VALUE_NULL: {
                    result = null;
                    break;
                }
                case VALUE_STRING: {
                    result = new BigDecimal(parser.getText());
                    result = result.setScale((int)scale, 4);
                    break;
                }
                case VALUE_NUMBER_FLOAT: 
                case VALUE_NUMBER_INT: {
                    result = parser.getDecimalValue();
                    result = result.setScale((int)scale, 4);
                    break;
                }
                case VALUE_TRUE: {
                    result = BigDecimal.ONE.setScale((int)scale, 4);
                    break;
                }
                case VALUE_FALSE: {
                    result = BigDecimal.ZERO.setScale((int)scale, 4);
                    break;
                }
                default: {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to DECIMAL(%s,%s)", json.toStringUtf8(), precision, scale));
                }
            }
            Failures.checkCondition(parser.nextToken() == null && (result == null || (long)result.precision() <= precision), (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to DECIMAL(%s,%s)", precision, scale);
            BigDecimal bigDecimal = result;
            return bigDecimal;
        }
        catch (IOException | NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to DECIMAL(%s,%s)", json.toStringUtf8(), precision, scale));
        }
    }
}

