/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.operator.scalar.annotations.ScalarOperator;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class BooleanOperators {
    private static final Slice TRUE = Slices.copiedBuffer((String)"true", (Charset)StandardCharsets.US_ASCII);
    private static final Slice FALSE = Slices.copiedBuffer((String)"false", (Charset)StandardCharsets.US_ASCII);

    private BooleanOperators() {
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    public static boolean equal(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left == right;
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    public static boolean notEqual(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left != right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN)
    @SqlType(value="boolean")
    public static boolean lessThan(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return !left && right;
    }

    @ScalarOperator(value=OperatorType.LESS_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean lessThanOrEqual(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return !left || right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN)
    @SqlType(value="boolean")
    public static boolean greaterThan(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left && !right;
    }

    @ScalarOperator(value=OperatorType.GREATER_THAN_OR_EQUAL)
    @SqlType(value="boolean")
    public static boolean greaterThanOrEqual(@SqlType(value="boolean") boolean left, @SqlType(value="boolean") boolean right) {
        return left || !right;
    }

    @ScalarOperator(value=OperatorType.BETWEEN)
    @SqlType(value="boolean")
    public static boolean between(@SqlType(value="boolean") boolean value, @SqlType(value="boolean") boolean min, @SqlType(value="boolean") boolean max) {
        return value && max || !value && !min;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="double")
    public static double castToDouble(@SqlType(value="boolean") boolean value) {
        return value ? 1.0 : 0.0;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="bigint")
    public static long castToBigint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="integer")
    public static long castToInteger(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="smallint")
    public static long castToSmallint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="tinyint")
    public static long castToTinyint(@SqlType(value="boolean") boolean value) {
        return value ? 1L : 0L;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="varchar")
    public static Slice castToVarchar(@SqlType(value="boolean") boolean value) {
        return value ? TRUE : FALSE;
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="boolean") boolean value) {
        return value ? 1231L : 1237L;
    }

    @SqlType(value="boolean")
    @ScalarFunction(hidden=true)
    public static boolean not(@SqlType(value="boolean") boolean value) {
        return !value;
    }
}

