/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.relational;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.InputReferenceExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.RowExpressionVisitor;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;

public final class Expressions {
    private Expressions() {
    }

    public static ConstantExpression constant(Object value, Type type) {
        return new ConstantExpression(value, type);
    }

    public static ConstantExpression constantNull(Type type) {
        return new ConstantExpression(null, type);
    }

    public static CallExpression call(Signature signature, Type returnType, RowExpression ... arguments) {
        return new CallExpression(signature, returnType, Arrays.asList(arguments));
    }

    public static CallExpression call(Signature signature, Type returnType, List<RowExpression> arguments) {
        return new CallExpression(signature, returnType, arguments);
    }

    public static InputReferenceExpression field(int field, Type type) {
        return new InputReferenceExpression(field, type);
    }

    public static List<RowExpression> subExpressions(Iterable<RowExpression> expressions) {
        final ImmutableList.Builder builder = ImmutableList.builder();
        for (RowExpression expression : expressions) {
            expression.accept(new RowExpressionVisitor<Void, Void>(){

                @Override
                public Void visitCall(CallExpression call, Void context) {
                    builder.add((Object)call);
                    for (RowExpression argument : call.getArguments()) {
                        argument.accept(this, context);
                    }
                    return null;
                }

                @Override
                public Void visitInputReference(InputReferenceExpression reference, Void context) {
                    builder.add((Object)reference);
                    return null;
                }

                @Override
                public Void visitConstant(ConstantExpression literal, Void context) {
                    builder.add((Object)literal);
                    return null;
                }
            }, null);
        }
        return builder.build();
    }
}

