/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.type.UnknownType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TypeValidator
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types) {
        plan.accept(new Visitor(session, metadata, sqlParser, types), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private final Session session;
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final Map<Symbol, Type> types;

        public Visitor(Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
            this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
            this.types = Objects.requireNonNull(types, "types is null");
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            AggregationNode.Step step = node.getStep();
            switch (step) {
                case SINGLE: {
                    this.checkFunctionSignature(node.getFunctions());
                    this.checkFunctionCall(node.getAggregations());
                    break;
                }
                case FINAL: {
                    this.checkFunctionSignature(node.getFunctions());
                }
            }
            return null;
        }

        @Override
        public Void visitWindow(WindowNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            this.checkFunctionSignature(node.getSignatures());
            this.checkFunctionCall(node.getWindowFunctions());
            return null;
        }

        @Override
        public Void visitProject(ProjectNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            for (Map.Entry<Symbol, Expression> entry : node.getAssignments().entrySet()) {
                Type expectedType = this.types.get(entry.getKey());
                if (entry.getValue() instanceof SymbolReference) {
                    SymbolReference symbolReference = (SymbolReference)entry.getValue();
                    Visitor.verifyTypeSignature(entry.getKey(), expectedType.getTypeSignature(), this.types.get(Symbol.from((Expression)symbolReference)).getTypeSignature());
                    continue;
                }
                Type actualType = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.types, entry.getValue()).get(entry.getValue());
                Visitor.verifyTypeSignature(entry.getKey(), expectedType.getTypeSignature(), actualType.getTypeSignature());
            }
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Void context) {
            this.visitPlan((PlanNode)node, context);
            ListMultimap<Symbol, Symbol> symbolMapping = node.getSymbolMapping();
            for (Symbol keySymbol : symbolMapping.keySet()) {
                List valueSymbols = symbolMapping.get((Object)keySymbol);
                Type expectedType = this.types.get(keySymbol);
                for (Symbol valueSymbol : valueSymbols) {
                    Visitor.verifyTypeSignature(keySymbol, expectedType.getTypeSignature(), this.types.get(valueSymbol).getTypeSignature());
                }
            }
            return null;
        }

        private void checkFunctionSignature(Map<Symbol, Signature> functions) {
            for (Map.Entry<Symbol, Signature> entry : functions.entrySet()) {
                TypeSignature expectedTypeSignature = this.types.get(entry.getKey()).getTypeSignature();
                TypeSignature actualTypeSignature = entry.getValue().getReturnType();
                Visitor.verifyTypeSignature(entry.getKey(), expectedTypeSignature, actualTypeSignature);
            }
        }

        private void checkFunctionCall(Map<Symbol, FunctionCall> functionCalls) {
            for (Map.Entry<Symbol, FunctionCall> entry : functionCalls.entrySet()) {
                Type expectedType = this.types.get(entry.getKey());
                Type actualType = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.types, (Expression)entry.getValue()).get(entry.getValue());
                Visitor.verifyTypeSignature(entry.getKey(), expectedType.getTypeSignature(), actualType.getTypeSignature());
            }
        }

        private static void verifyTypeSignature(Symbol symbol, TypeSignature expected, TypeSignature actual) {
            if (!actual.equals((Object)UnknownType.UNKNOWN.getTypeSignature())) {
                Preconditions.checkArgument((boolean)expected.equals((Object)actual), (String)"type of symbol '%s' is expected to be %s, but the actual type is %s", (Object[])new Object[]{symbol, expected, actual});
            }
        }
    }
}

