/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.sanity.NoApplyNodeLeftChecker;
import com.facebook.presto.sql.planner.sanity.NoSubqueryExpressionLeftChecker;
import com.facebook.presto.sql.planner.sanity.TypeValidator;
import com.facebook.presto.sql.planner.sanity.ValidateDependenciesChecker;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public final class PlanSanityChecker {
    private static final List<Checker> CHECKERS = ImmutableList.of((Object)new ValidateDependenciesChecker(), (Object)new TypeValidator(), (Object)new NoSubqueryExpressionLeftChecker(), (Object)new NoApplyNodeLeftChecker());

    private PlanSanityChecker() {
    }

    public static void validate(PlanNode planNode, Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types) {
        CHECKERS.forEach(checker -> checker.validate(planNode, session, metadata, sqlParser, types));
    }

    public static interface Checker {
        public void validate(PlanNode var1, Session var2, Metadata var3, SqlParser var4, Map<Symbol, Type> var5);
    }
}

