/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GroupIdNode
extends PlanNode {
    private final PlanNode source;
    private final List<List<Symbol>> groupingSets;
    private final Map<Symbol, Symbol> identityMappings;
    private final Symbol groupIdSymbol;

    @JsonCreator
    public GroupIdNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="groupingSets") List<List<Symbol>> groupingSets, @JsonProperty(value="identityMappings") Map<Symbol, Symbol> identityMappings, @JsonProperty(value="groupIdSymbol") Symbol groupIdSymbol) {
        super(id);
        this.source = Objects.requireNonNull(source);
        this.groupingSets = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingSets));
        this.identityMappings = ImmutableMap.copyOf(Objects.requireNonNull(identityMappings));
        this.groupIdSymbol = Objects.requireNonNull(groupIdSymbol);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.getDistinctGroupingColumns()).addAll(this.identityMappings.values()).add((Object)this.groupIdSymbol).build();
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    public Set<Symbol> getInputSymbols() {
        return ImmutableSet.builder().addAll(this.identityMappings.keySet()).addAll(this.getDistinctGroupingColumns()).build();
    }

    @JsonProperty
    public List<List<Symbol>> getGroupingSets() {
        return this.groupingSets;
    }

    @JsonProperty
    public Map<Symbol, Symbol> getIdentityMappings() {
        return this.identityMappings;
    }

    public List<Symbol> getDistinctGroupingColumns() {
        return this.groupingSets.stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    public List<Symbol> getCommonGroupingColumns() {
        HashSet intersection = new HashSet(this.groupingSets.get(0));
        for (int i = 1; i < this.getGroupingSets().size(); ++i) {
            intersection.retainAll((Collection)this.groupingSets.get(i));
        }
        return ImmutableList.copyOf(intersection);
    }

    @JsonProperty
    public Symbol getGroupIdSymbol() {
        return this.groupIdSymbol;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitGroupId(this, context);
    }
}

