/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionSymbolInliner;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.TryExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MergeProjections
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            if (source instanceof ProjectNode && ((ProjectNode)source).getAssignments().values().stream().allMatch(DeterminismEvaluator::isDeterministic) && node.getAssignments().values().stream().noneMatch(e -> e instanceof TryExpression)) {
                ImmutableMap.Builder projections = ImmutableMap.builder();
                for (Map.Entry<Symbol, Expression> projection : node.getAssignments().entrySet()) {
                    Expression inlined = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionSymbolInliner(((ProjectNode)source).getAssignments()), (Expression)projection.getValue());
                    projections.put((Object)projection.getKey(), (Object)inlined);
                }
                return new ProjectNode(node.getId(), ((ProjectNode)source).getSource(), (Map<Symbol, Expression>)projections.build());
            }
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)source));
        }
    }
}

