/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DesugaringRewriter;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;

public class DesugaringOptimizer
implements PlanOptimizer {
    private final Metadata metadata;
    private final SqlParser sqlParser;

    public DesugaringOptimizer(Metadata metadata, SqlParser sqlParser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(this.metadata, this.sqlParser, session, types), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private final Metadata metadata;
        private final SqlParser sqlParser;
        private final Session session;
        private final Map<Symbol, Type> types;

        public Rewriter(Metadata metadata, SqlParser sqlParser, Session session, Map<Symbol, Type> types) {
            this.metadata = metadata;
            this.sqlParser = sqlParser;
            this.session = session;
            this.types = types;
        }

        @Override
        public PlanNode visitProject(ProjectNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            ImmutableMap assignments = ImmutableMap.copyOf((Map)Maps.transformValues(node.getAssignments(), this::desugar));
            return new ProjectNode(node.getId(), source, (Map<Symbol, Expression>)assignments);
        }

        @Override
        public PlanNode visitFilter(FilterNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PlanNode source = context.rewrite(node.getSource());
            Expression cleaned = this.desugar(node.getPredicate());
            return new FilterNode(node.getId(), source, cleaned);
        }

        @Override
        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            Expression originalConstraint = null;
            if (node.getOriginalConstraint() != null) {
                originalConstraint = this.desugar(node.getOriginalConstraint());
            }
            return new TableScanNode(node.getId(), node.getTable(), node.getOutputSymbols(), node.getAssignments(), node.getLayout(), node.getCurrentConstraint(), originalConstraint);
        }

        private Expression desugar(Expression expression) {
            if (expression instanceof SymbolReference) {
                return expression;
            }
            IdentityHashMap<Expression, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(this.session, this.metadata, this.sqlParser, this.types, expression);
            return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new DesugaringRewriter(expressionTypes), (Expression)expression);
        }
    }
}

