/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CountConstantOptimizer
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan);
    }

    private static class Rewriter
    extends SimplePlanRewriter<Void> {
        private Rewriter() {
        }

        @Override
        public PlanNode visitAggregation(AggregationNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            LinkedHashMap<Symbol, FunctionCall> aggregations = new LinkedHashMap<Symbol, FunctionCall>(node.getAggregations());
            LinkedHashMap<Symbol, Signature> functions = new LinkedHashMap<Symbol, Signature>(node.getFunctions());
            PlanNode source = context.rewrite(node.getSource());
            if (source instanceof ProjectNode) {
                ProjectNode projectNode = (ProjectNode)source;
                for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                    Signature signature;
                    Symbol symbol = entry.getKey();
                    FunctionCall functionCall = entry.getValue();
                    if (!Rewriter.isCountConstant(projectNode, functionCall, signature = node.getFunctions().get(symbol))) continue;
                    aggregations.put(symbol, new FunctionCall(functionCall.getName(), functionCall.isDistinct(), (List)ImmutableList.of()));
                    functions.put(symbol, new Signature("count", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[0]));
                }
            }
            return new AggregationNode(node.getId(), source, node.getGroupBy(), aggregations, functions, node.getMasks(), node.getGroupingSets(), node.getStep(), node.getSampleWeight(), node.getConfidence(), node.getHashSymbol());
        }

        public static boolean isCountConstant(ProjectNode projectNode, FunctionCall functionCall, Signature signature) {
            if (!"count".equals(signature.getName()) || signature.getArgumentTypes().size() != 1 || !signature.getReturnType().getBase().equals("bigint")) {
                return false;
            }
            Expression argument = (Expression)functionCall.getArguments().get(0);
            if (argument instanceof Literal && !(argument instanceof NullLiteral)) {
                return true;
            }
            if (argument instanceof SymbolReference) {
                Symbol argumentSymbol = Symbol.from(argument);
                Expression argumentExpression = projectNode.getAssignments().get(argumentSymbol);
                return argumentExpression instanceof Literal && !(argumentExpression instanceof NullLiteral);
            }
            return false;
        }
    }
}

