/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.GroupingProperty;
import com.facebook.presto.spi.LocalProperty;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.optimizations.LocalProperties;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.optimizations.StreamPreferredProperties;
import com.facebook.presto.sql.planner.optimizations.StreamPropertyDerivations;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AddLocalExchanges
implements PlanOptimizer {
    private final Metadata metadata;
    private final SqlParser parser;

    public AddLocalExchanges(Metadata metadata, SqlParser parser) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.parser = Objects.requireNonNull(parser, "parser is null");
    }

    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        PlanWithProperties result = plan.accept(new Rewriter(symbolAllocator, idAllocator, session), StreamPreferredProperties.any());
        return result.getNode();
    }

    private static class PlanWithProperties {
        private final PlanNode node;
        private final StreamPropertyDerivations.StreamProperties properties;

        public PlanWithProperties(PlanNode node, StreamPropertyDerivations.StreamProperties properties) {
            this.node = Objects.requireNonNull(node, "node is null");
            this.properties = Objects.requireNonNull(properties, "StreamProperties is null");
        }

        public PlanNode getNode() {
            return this.node;
        }

        public StreamPropertyDerivations.StreamProperties getProperties() {
            return this.properties;
        }
    }

    private class Rewriter
    extends PlanVisitor<StreamPreferredProperties, PlanWithProperties> {
        private final SymbolAllocator symbolAllocator;
        private final PlanNodeIdAllocator idAllocator;
        private final Session session;

        public Rewriter(SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Session session) {
            this.symbolAllocator = symbolAllocator;
            this.idAllocator = idAllocator;
            this.session = session;
        }

        @Override
        protected PlanWithProperties visitPlan(PlanNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, parentPreferences.withoutPreference().withDefaultParallelism(this.session), parentPreferences.withDefaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitOutput(OutputNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.any().withOrderSensitivity(), StreamPreferredProperties.any().withOrderSensitivity());
        }

        @Override
        public PlanWithProperties visitExplainAnalyze(ExplainAnalyzeNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream().withOrderSensitivity(), StreamPreferredProperties.singleStream().withOrderSensitivity());
        }

        @Override
        public PlanWithProperties visitSort(SortNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitTableFinish(TableFinishNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitTopN(TopNNode node, StreamPreferredProperties parentPreferences) {
            if (node.isPartial()) {
                return this.planAndEnforceChildren(node, parentPreferences.withoutPreference().withDefaultParallelism(this.session), parentPreferences.withDefaultParallelism(this.session));
            }
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitLimit(LimitNode node, StreamPreferredProperties parentPreferences) {
            if (node.isPartial()) {
                return this.planAndEnforceChildren(node, parentPreferences.withoutPreference().withDefaultParallelism(this.session), parentPreferences.withDefaultParallelism(this.session));
            }
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitDistinctLimit(DistinctLimitNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties preferredProperties;
            StreamPreferredProperties requiredProperties;
            if (node.isPartial()) {
                requiredProperties = parentPreferences.withoutPreference().withDefaultParallelism(this.session);
                preferredProperties = parentPreferences.withDefaultParallelism(this.session);
            } else {
                requiredProperties = StreamPreferredProperties.singleStream();
                preferredProperties = StreamPreferredProperties.defaultParallelism(this.session);
            }
            return this.planAndEnforceChildren(node, requiredProperties, preferredProperties);
        }

        @Override
        public PlanWithProperties visitEnforceSingleRow(EnforceSingleRowNode node, StreamPreferredProperties parentPreferences) {
            return this.planAndEnforceChildren(node, StreamPreferredProperties.singleStream(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitAggregation(AggregationNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties preferredChildProperties;
            StreamPreferredProperties requiredProperties;
            if (node.getStep() == AggregationNode.Step.FINAL || node.getStep() == AggregationNode.Step.SINGLE) {
                HashSet<Symbol> partitioningRequirement = new HashSet<Symbol>((Collection)node.getGroupingSets().get(0));
                for (int i = 1; i < node.getGroupingSets().size(); ++i) {
                    partitioningRequirement.retainAll((Collection)node.getGroupingSets().get(i));
                }
                requiredProperties = parentPreferences.withDefaultParallelism(this.session).withPartitioning(partitioningRequirement);
                preferredChildProperties = parentPreferences.withDefaultParallelism(this.session).withPartitioning(partitioningRequirement);
            } else {
                requiredProperties = parentPreferences.withoutPreference().withDefaultParallelism(this.session);
                preferredChildProperties = parentPreferences.withDefaultParallelism(this.session).constrainTo(node.getSource().getOutputSymbols());
            }
            PlanWithProperties child = node.getSource().accept(this, preferredChildProperties);
            if (requiredProperties.isSatisfiedBy(child.getProperties())) {
                return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)child));
            }
            FunctionRegistry functionRegistry = AddLocalExchanges.this.metadata.getFunctionRegistry();
            boolean decomposable = node.getFunctions().values().stream().map(functionRegistry::getAggregateFunctionImplementation).allMatch(InternalAggregationFunction::isDecomposable);
            if (decomposable && !requiredProperties.isParallelPreferred()) {
                return this.splitAggregation(node, child, source -> ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, source));
            }
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)this.enforce(child, requiredProperties)));
        }

        private PlanWithProperties splitAggregation(AggregationNode node, PlanWithProperties newChild, Function<PlanNode, PlanNode> exchanger) {
            Map<Symbol, Symbol> masks = node.getMasks();
            HashMap<Symbol, FunctionCall> finalCalls = new HashMap<Symbol, FunctionCall>();
            HashMap<Symbol, FunctionCall> intermediateCalls = new HashMap<Symbol, FunctionCall>();
            HashMap<Symbol, Signature> intermediateFunctions = new HashMap<Symbol, Signature>();
            HashMap<Symbol, Symbol> intermediateMask = new HashMap<Symbol, Symbol>();
            for (Map.Entry<Symbol, FunctionCall> entry : node.getAggregations().entrySet()) {
                Signature signature = node.getFunctions().get(entry.getKey());
                InternalAggregationFunction function = AddLocalExchanges.this.metadata.getFunctionRegistry().getAggregateFunctionImplementation(signature);
                Symbol intermediateSymbol = this.symbolAllocator.newSymbol(signature.getName(), function.getIntermediateType());
                intermediateCalls.put(intermediateSymbol, entry.getValue());
                intermediateFunctions.put(intermediateSymbol, signature);
                if (masks.containsKey(entry.getKey())) {
                    intermediateMask.put(intermediateSymbol, masks.get(entry.getKey()));
                }
                finalCalls.put(entry.getKey(), new FunctionCall(QualifiedName.of((String)signature.getName()), (List)ImmutableList.of((Object)intermediateSymbol.toSymbolReference())));
            }
            PlanWithProperties source = this.deriveProperties((PlanNode)new AggregationNode(this.idAllocator.getNextId(), newChild.getNode(), node.getGroupBy(), intermediateCalls, intermediateFunctions, intermediateMask, node.getGroupingSets(), AggregationNode.Step.PARTIAL, node.getSampleWeight(), node.getConfidence(), node.getHashSymbol()), newChild.getProperties());
            if (exchanger != null) {
                source = this.deriveProperties(exchanger.apply(source.getNode()), source.getProperties());
            }
            return this.deriveProperties((PlanNode)new AggregationNode(node.getId(), source.getNode(), node.getGroupBy(), finalCalls, node.getFunctions(), (Map<Symbol, Symbol>)ImmutableMap.of(), node.getGroupingSets(), AggregationNode.Step.FINAL, Optional.empty(), node.getConfidence(), node.getHashSymbol()), source.getProperties());
        }

        @Override
        public PlanWithProperties visitWindow(WindowNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties childRequirements = parentPreferences.constrainTo(node.getSource().getOutputSymbols()).withDefaultParallelism(this.session).withPartitioning(node.getPartitionBy());
            PlanWithProperties child = this.planAndEnforce(node.getSource(), childRequirements, childRequirements);
            ArrayList desiredProperties = new ArrayList();
            if (!node.getPartitionBy().isEmpty()) {
                desiredProperties.add(new GroupingProperty(node.getPartitionBy()));
            }
            for (Symbol symbol2 : node.getOrderBy()) {
                desiredProperties.add(new SortingProperty((Object)symbol2, node.getOrderings().get(symbol2)));
            }
            Iterator matchIterator = LocalProperties.match(child.getProperties().getLocalProperties(), desiredProperties).iterator();
            Object prePartitionedInputs = ImmutableSet.of();
            if (!node.getPartitionBy().isEmpty()) {
                Optional<LocalProperty<LocalProperty>> groupingRequirement = matchIterator.next();
                Set unPartitionedInputs = groupingRequirement.map(LocalProperty::getColumns).orElse((Set)ImmutableSet.of());
                prePartitionedInputs = (Set)node.getPartitionBy().stream().filter(symbol -> !unPartitionedInputs.contains(symbol)).collect(ImmutableCollectors.toImmutableSet());
            }
            int preSortedOrderPrefix = 0;
            if (prePartitionedInputs.equals(ImmutableSet.copyOf(node.getPartitionBy()))) {
                while (matchIterator.hasNext() && !matchIterator.next().isPresent()) {
                    ++preSortedOrderPrefix;
                }
            }
            WindowNode result = new WindowNode(node.getId(), child.getNode(), node.getSpecification(), node.getWindowFunctions(), node.getSignatures(), node.getHashSymbol(), (Set<Symbol>)prePartitionedInputs, preSortedOrderPrefix);
            return this.deriveProperties((PlanNode)result, child.getProperties());
        }

        @Override
        public PlanWithProperties visitMarkDistinct(MarkDistinctNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties requiredProperties = parentPreferences.withDefaultParallelism(this.session).withPartitioning(node.getDistinctSymbols());
            return this.planAndEnforceChildren(node, requiredProperties, requiredProperties);
        }

        @Override
        public PlanWithProperties visitRowNumber(RowNumberNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties requiredProperties = parentPreferences.withDefaultParallelism(this.session).withPartitioning(node.getPartitionBy());
            return this.planAndEnforceChildren(node, requiredProperties, requiredProperties);
        }

        @Override
        public PlanWithProperties visitTopNRowNumber(TopNRowNumberNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties requiredProperties = parentPreferences.withDefaultParallelism(this.session);
            if (!node.isPartial()) {
                requiredProperties = requiredProperties.withPartitioning(node.getPartitionBy());
            }
            return this.planAndEnforceChildren(node, requiredProperties, requiredProperties);
        }

        @Override
        public PlanWithProperties visitTableWriter(TableWriterNode node, StreamPreferredProperties parentPreferences) {
            StreamPreferredProperties preferredProperties;
            StreamPreferredProperties requiredProperties;
            if (SystemSessionProperties.getTaskWriterCount(this.session) > 1) {
                requiredProperties = StreamPreferredProperties.fixedParallelism();
                preferredProperties = StreamPreferredProperties.fixedParallelism();
            } else {
                requiredProperties = StreamPreferredProperties.singleStream();
                preferredProperties = StreamPreferredProperties.defaultParallelism(this.session);
            }
            return this.planAndEnforceChildren(node, requiredProperties, preferredProperties);
        }

        @Override
        public PlanWithProperties visitExchange(ExchangeNode node, StreamPreferredProperties parentPreferences) {
            Preconditions.checkArgument((node.getScope() != ExchangeNode.Scope.LOCAL ? 1 : 0) != 0, (Object)"AddLocalExchanges can not process a plan containing a local exchange");
            return this.planAndEnforceChildren(node, StreamPreferredProperties.any(), StreamPreferredProperties.defaultParallelism(this.session));
        }

        @Override
        public PlanWithProperties visitUnion(UnionNode node, StreamPreferredProperties preferredProperties) {
            ExchangeNode result;
            List sourcesWithProperties = (List)node.getSources().stream().map(source -> source.accept(this, StreamPreferredProperties.defaultParallelism(this.session))).collect(ImmutableCollectors.toImmutableList());
            List sources = (List)sourcesWithProperties.stream().map(PlanWithProperties::getNode).collect(ImmutableCollectors.toImmutableList());
            List inputProperties = (List)sourcesWithProperties.stream().map(PlanWithProperties::getProperties).collect(ImmutableCollectors.toImmutableList());
            ArrayList<List<Symbol>> inputLayouts = new ArrayList<List<Symbol>>(sources.size());
            for (int i = 0; i < sources.size(); ++i) {
                inputLayouts.add(node.sourceOutputLayout(i));
            }
            if (preferredProperties.isSingleStreamPreferred()) {
                ExchangeNode exchangeNode = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.GATHER, ExchangeNode.Scope.LOCAL, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), node.getOutputSymbols()), sources, inputLayouts);
                return this.deriveProperties((PlanNode)exchangeNode, inputProperties);
            }
            Optional<List<Symbol>> preferredPartitionColumns = preferredProperties.getPartitioningColumns();
            if (preferredPartitionColumns.isPresent()) {
                ExchangeNode exchangeNode = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.LOCAL, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, preferredPartitionColumns.get()), node.getOutputSymbols(), Optional.empty()), sources, inputLayouts);
                return this.deriveProperties((PlanNode)exchangeNode, inputProperties);
            }
            ExchangeNode exchangeNode = result = new ExchangeNode(this.idAllocator.getNextId(), ExchangeNode.Type.REPARTITION, ExchangeNode.Scope.LOCAL, new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_RANDOM_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), node.getOutputSymbols()), sources, inputLayouts);
            return this.deriveProperties((PlanNode)exchangeNode, inputProperties);
        }

        @Override
        public PlanWithProperties visitJoin(JoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties probe = this.planAndEnforce(node.getLeft(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getLeft().getOutputSymbols()).withDefaultParallelism(this.session));
            List buildHashSymbols = Lists.transform(node.getCriteria(), JoinNode.EquiJoinClause::getRight);
            StreamPreferredProperties buildPreference = SystemSessionProperties.getTaskConcurrency(this.session) > 1 ? StreamPreferredProperties.exactlyPartitionedOn(buildHashSymbols) : StreamPreferredProperties.singleStream();
            PlanWithProperties build = this.planAndEnforce(node.getRight(), buildPreference, buildPreference);
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)probe, (Object)build));
        }

        @Override
        public PlanWithProperties visitSemiJoin(SemiJoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties source = this.planAndEnforce(node.getSource(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getSource().getOutputSymbols()).withDefaultParallelism(this.session));
            PlanWithProperties filteringSource = this.planAndEnforce(node.getFilteringSource(), StreamPreferredProperties.singleStream(), StreamPreferredProperties.singleStream());
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)source, (Object)filteringSource));
        }

        @Override
        public PlanWithProperties visitIndexJoin(IndexJoinNode node, StreamPreferredProperties parentPreferences) {
            PlanWithProperties probe = this.planAndEnforce(node.getProbeSource(), StreamPreferredProperties.defaultParallelism(this.session), parentPreferences.constrainTo(node.getProbeSource().getOutputSymbols()).withDefaultParallelism(this.session));
            StreamPropertyDerivations.StreamProperties indexStreamProperties = this.derivePropertiesRecursively(node.getIndexSource());
            Preconditions.checkArgument((indexStreamProperties.getDistribution() == StreamPropertyDerivations.StreamProperties.StreamDistribution.SINGLE ? 1 : 0) != 0, (Object)"index source must be single stream");
            PlanWithProperties index = new PlanWithProperties(node.getIndexSource(), indexStreamProperties);
            return this.rebaseAndDeriveProperties(node, (List<PlanWithProperties>)ImmutableList.of((Object)probe, (Object)index));
        }

        private PlanWithProperties planAndEnforceChildren(PlanNode node, StreamPreferredProperties requiredProperties, StreamPreferredProperties preferredProperties) {
            List children = (List)node.getSources().stream().map(source -> this.planAndEnforce((PlanNode)source, requiredProperties.constrainTo(source.getOutputSymbols()), preferredProperties.constrainTo(source.getOutputSymbols()))).collect(ImmutableCollectors.toImmutableList());
            return this.rebaseAndDeriveProperties(node, children);
        }

        private PlanWithProperties planAndEnforce(PlanNode node, StreamPreferredProperties requiredProperties, StreamPreferredProperties preferredProperties) {
            List<Symbol> outputSymbols = node.getOutputSymbols();
            Preconditions.checkArgument((boolean)requiredProperties.getPartitioningColumns().map(outputSymbols::containsAll).orElse(true));
            Preconditions.checkArgument((boolean)preferredProperties.getPartitioningColumns().map(outputSymbols::containsAll).orElse(true));
            PlanWithProperties result = node.accept(this, preferredProperties);
            result = this.enforce(result, requiredProperties);
            return result;
        }

        private PlanWithProperties enforce(PlanWithProperties planWithProperties, StreamPreferredProperties requiredProperties) {
            if (requiredProperties.isSatisfiedBy(planWithProperties.getProperties())) {
                return planWithProperties;
            }
            if (requiredProperties.isSingleStreamPreferred()) {
                ExchangeNode exchangeNode = ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode());
                return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
            }
            Optional<List<Symbol>> requiredPartitionColumns = requiredProperties.getPartitioningColumns();
            if (!requiredPartitionColumns.isPresent()) {
                ExchangeNode exchangeNode = ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode(), new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.FIXED_RANDOM_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), planWithProperties.getNode().getOutputSymbols()));
                return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
            }
            if (requiredProperties.isParallelPreferred()) {
                ExchangeNode exchangeNode = ExchangeNode.partitionedExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode(), requiredPartitionColumns.get(), Optional.empty());
                return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
            }
            ExchangeNode exchangeNode = ExchangeNode.gatheringExchange(this.idAllocator.getNextId(), ExchangeNode.Scope.LOCAL, planWithProperties.getNode());
            return this.deriveProperties((PlanNode)exchangeNode, planWithProperties.getProperties());
        }

        private PlanWithProperties rebaseAndDeriveProperties(PlanNode node, List<PlanWithProperties> children) {
            PlanNode result = ChildReplacer.replaceChildren(node, children.stream().map(PlanWithProperties::getNode).collect(Collectors.toList()));
            List inputProperties = (List)children.stream().map(PlanWithProperties::getProperties).collect(ImmutableCollectors.toImmutableList());
            return this.deriveProperties(result, inputProperties);
        }

        private PlanWithProperties deriveProperties(PlanNode result, StreamPropertyDerivations.StreamProperties inputProperties) {
            return new PlanWithProperties(result, StreamPropertyDerivations.deriveProperties(result, inputProperties, AddLocalExchanges.this.metadata, this.session, this.symbolAllocator.getTypes(), AddLocalExchanges.this.parser));
        }

        private PlanWithProperties deriveProperties(PlanNode result, List<StreamPropertyDerivations.StreamProperties> inputProperties) {
            return new PlanWithProperties(result, StreamPropertyDerivations.deriveProperties(result, inputProperties, AddLocalExchanges.this.metadata, this.session, this.symbolAllocator.getTypes(), AddLocalExchanges.this.parser));
        }

        private StreamPropertyDerivations.StreamProperties derivePropertiesRecursively(PlanNode node) {
            List inputProperties = (List)node.getSources().stream().map(this::derivePropertiesRecursively).collect(ImmutableCollectors.toImmutableList());
            return StreamPropertyDerivations.deriveProperties(node, inputProperties, AddLocalExchanges.this.metadata, this.session, this.symbolAllocator.getTypes(), AddLocalExchanges.this.parser);
        }
    }
}

