/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class TranslationMap {
    private final RelationPlan rewriteBase;
    private final Analysis analysis;
    private final Symbol[] fieldSymbols;
    private final Map<Expression, Symbol> expressionToSymbols = new HashMap<Expression, Symbol>();
    private final Map<Expression, Expression> expressionToExpressions = new HashMap<Expression, Expression>();

    public TranslationMap(RelationPlan rewriteBase, Analysis analysis) {
        this.rewriteBase = rewriteBase;
        this.analysis = analysis;
        this.fieldSymbols = new Symbol[rewriteBase.getOutputSymbols().size()];
    }

    public RelationPlan getRelationPlan() {
        return this.rewriteBase;
    }

    public Analysis getAnalysis() {
        return this.analysis;
    }

    public void setFieldMappings(List<Symbol> symbols) {
        Preconditions.checkArgument((symbols.size() == this.fieldSymbols.length ? 1 : 0) != 0, (String)"size of symbols list (%s) doesn't match number of expected fields (%s)", (Object[])new Object[]{symbols.size(), this.fieldSymbols.length});
        for (int i = 0; i < symbols.size(); ++i) {
            this.fieldSymbols[i] = symbols.get(i);
        }
    }

    public void copyMappingsFrom(TranslationMap other) {
        Preconditions.checkArgument((other.fieldSymbols.length == this.fieldSymbols.length ? 1 : 0) != 0, (String)"number of fields in other (%s) doesn't match number of expected fields (%s)", (Object[])new Object[]{other.fieldSymbols.length, this.fieldSymbols.length});
        this.expressionToSymbols.putAll(other.expressionToSymbols);
        this.expressionToExpressions.putAll(other.expressionToExpressions);
        System.arraycopy(other.fieldSymbols, 0, this.fieldSymbols, 0, other.fieldSymbols.length);
    }

    public void putExpressionMappingsFrom(TranslationMap other) {
        this.expressionToSymbols.putAll(other.expressionToSymbols);
    }

    public Expression rewrite(Expression expression) {
        Expression mapped = this.translateNamesToSymbols(expression);
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                if (TranslationMap.this.expressionToSymbols.containsKey(node)) {
                    return ((Symbol)TranslationMap.this.expressionToSymbols.get(node)).toSymbolReference();
                }
                if (TranslationMap.this.expressionToExpressions.containsKey(node)) {
                    Expression mapping = (Expression)TranslationMap.this.expressionToExpressions.get(node);
                    mapping = TranslationMap.this.translateNamesToSymbols(mapping);
                    return treeRewriter.defaultRewrite(mapping, (Object)context);
                }
                return treeRewriter.defaultRewrite(node, (Object)context);
            }
        }, (Expression)mapped);
    }

    public void put(Expression expression, Symbol symbol) {
        if (expression instanceof FieldReference) {
            int fieldIndex = ((FieldReference)expression).getFieldIndex();
            this.fieldSymbols[fieldIndex] = symbol;
            this.expressionToSymbols.put((Expression)this.rewriteBase.getSymbol(fieldIndex).toSymbolReference(), symbol);
            return;
        }
        Expression translated = this.translateNamesToSymbols(expression);
        this.expressionToSymbols.put(translated, symbol);
        this.analysis.getFieldIndex(expression).ifPresent(index -> {
            this.fieldSymbols[index.intValue()] = symbol;
        });
    }

    public boolean containsSymbol(Expression expression) {
        if (expression instanceof FieldReference) {
            int field = ((FieldReference)expression).getFieldIndex();
            return this.fieldSymbols[field] != null;
        }
        Expression translated = this.translateNamesToSymbols(expression);
        return this.expressionToSymbols.containsKey(translated);
    }

    public Symbol get(Expression expression) {
        if (expression instanceof FieldReference) {
            int field = ((FieldReference)expression).getFieldIndex();
            Preconditions.checkArgument((this.fieldSymbols[field] != null ? 1 : 0) != 0, (String)"No mapping for field: %s", (Object[])new Object[]{field});
            return this.fieldSymbols[field];
        }
        Expression translated = this.translateNamesToSymbols(expression);
        Preconditions.checkArgument((boolean)this.expressionToSymbols.containsKey(translated), (String)"No mapping for expression: %s", (Object[])new Object[]{expression});
        return this.expressionToSymbols.get(translated);
    }

    public void put(Expression expression, Expression rewritten) {
        this.expressionToExpressions.put(this.translateNamesToSymbols(expression), rewritten);
    }

    private Expression translateNamesToSymbols(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                return this.coerceIfNecessary(node, rewrittenExpression);
            }

            public Expression rewriteFieldReference(FieldReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Symbol symbol = TranslationMap.this.rewriteBase.getSymbol(node.getFieldIndex());
                Preconditions.checkState((symbol != null ? 1 : 0) != 0, (String)"No symbol mapping for node '%s' (%s)", (Object[])new Object[]{node, node.getFieldIndex()});
                return symbol.toSymbolReference();
            }

            public Expression rewriteQualifiedNameReference(QualifiedNameReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return this.rewriteExpressionWithResolvedName((Expression)node);
            }

            private Expression rewriteExpressionWithResolvedName(Expression node) {
                Optional<Integer> fieldIndex = TranslationMap.this.analysis.getFieldIndex(node);
                Preconditions.checkState((boolean)fieldIndex.isPresent(), (String)"No field mapping for node '%s'", (Object[])new Object[]{node});
                Symbol symbol = TranslationMap.this.rewriteBase.getSymbol(fieldIndex.get());
                Preconditions.checkState((symbol != null ? 1 : 0) != 0, (String)"No symbol mapping for node '%s' (%s)", (Object[])new Object[]{node, fieldIndex.get()});
                SymbolReference rewrittenExpression = symbol.toSymbolReference();
                return this.coerceIfNecessary(node, (Expression)rewrittenExpression);
            }

            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                if (TranslationMap.this.analysis.getFieldIndex((Expression)node).isPresent()) {
                    return this.rewriteExpressionWithResolvedName((Expression)node);
                }
                return this.rewriteExpression((Expression)node, context, treeRewriter);
            }

            private Expression coerceIfNecessary(Expression original, Expression rewritten) {
                Type coercion = TranslationMap.this.analysis.getCoercion(original);
                if (coercion != null) {
                    rewritten = new Cast(rewritten, coercion.getTypeSignature().toString(), false, TranslationMap.this.analysis.isTypeOnlyCoercion(original));
                }
                return rewritten;
            }
        }, (Expression)expression);
    }
}

