/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.sql.util.AstUtils;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

class SubqueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Session session;

    SubqueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.session = session;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Collection<Expression> expressions, Node node) {
        for (Expression expression : expressions) {
            builder = this.handleSubqueries(builder, expression, node);
        }
        return builder;
    }

    public PlanBuilder handleSubqueries(PlanBuilder builder, Expression expression, Node node) {
        builder = this.appendInPredicateApplyNodes(builder, (Set)this.analysis.getInPredicateSubqueries(node).stream().filter(inPredicate -> AstUtils.nodeContains((Node)expression, (Node)inPredicate.getValueList())).collect(ImmutableCollectors.toImmutableSet()));
        builder = this.appendScalarSubqueryApplyNodes(builder, (Set)this.analysis.getScalarSubqueries(node).stream().filter(subquery -> AstUtils.nodeContains((Node)expression, (Node)subquery)).collect(ImmutableCollectors.toImmutableSet()));
        return builder;
    }

    private PlanBuilder appendInPredicateApplyNodes(PlanBuilder subPlan, Set<InPredicate> inPredicates) {
        for (InPredicate inPredicate : inPredicates) {
            subPlan = this.appendInPredicateApplyNode(subPlan, inPredicate);
        }
        return subPlan;
    }

    private PlanBuilder appendInPredicateApplyNode(PlanBuilder subPlan, InPredicate inPredicate) {
        subPlan = subPlan.appendProjections((Iterable<Expression>)ImmutableList.of((Object)inPredicate.getValue()), this.symbolAllocator, this.idAllocator);
        Preconditions.checkState((boolean)(inPredicate.getValueList() instanceof SubqueryExpression));
        RelationPlan valueListRelation = this.createRelationPlan((SubqueryExpression)inPredicate.getValueList());
        TranslationMap translationMap = subPlan.copyTranslations();
        SymbolReference valueList = ((Symbol)Iterables.getOnlyElement(valueListRelation.getOutputSymbols())).toSymbolReference();
        translationMap.put((Expression)inPredicate, (Expression)new InPredicate(inPredicate.getValue(), (Expression)valueList));
        return new PlanBuilder(translationMap, new ApplyNode(this.idAllocator.getNextId(), subPlan.getRoot(), valueListRelation.getRoot(), (List<Symbol>)ImmutableList.of()), subPlan.getSampleWeight());
    }

    private PlanBuilder appendScalarSubqueryApplyNodes(PlanBuilder builder, Set<SubqueryExpression> scalarSubqueries) {
        for (SubqueryExpression scalarSubquery : scalarSubqueries) {
            builder = this.appendScalarSubqueryApplyNode(builder, scalarSubquery);
        }
        return builder;
    }

    private PlanBuilder appendScalarSubqueryApplyNode(PlanBuilder subPlan, SubqueryExpression scalarSubquery) {
        if (subPlan.canTranslate((Expression)scalarSubquery)) {
            return subPlan;
        }
        EnforceSingleRowNode enforceSingleRowNode = new EnforceSingleRowNode(this.idAllocator.getNextId(), this.createRelationPlan(scalarSubquery).getRoot());
        TranslationMap translations = subPlan.copyTranslations();
        translations.put((Expression)scalarSubquery, (Symbol)Iterables.getOnlyElement(enforceSingleRowNode.getOutputSymbols()));
        PlanNode root = subPlan.getRoot();
        if (root.getOutputSymbols().isEmpty()) {
            return new PlanBuilder(translations, enforceSingleRowNode, subPlan.getSampleWeight());
        }
        return new PlanBuilder(translations, new ApplyNode(this.idAllocator.getNextId(), root, enforceSingleRowNode, (List<Symbol>)ImmutableList.of()), subPlan.getSampleWeight());
    }

    private RelationPlan createRelationPlan(SubqueryExpression subqueryExpression) {
        return (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)subqueryExpression.getQuery(), null);
    }
}

