/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.planner.PlanBuilder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.SubqueryPlanner;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TranslationMap;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

class QueryPlanner {
    private final Analysis analysis;
    private final SymbolAllocator symbolAllocator;
    private final PlanNodeIdAllocator idAllocator;
    private final Metadata metadata;
    private final Session session;
    private final Optional<Double> approximationConfidence;
    private final SubqueryPlanner subqueryPlanner;

    QueryPlanner(Analysis analysis, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator, Metadata metadata, Session session, Optional<Double> approximationConfidence) {
        Objects.requireNonNull(analysis, "analysis is null");
        Objects.requireNonNull(symbolAllocator, "symbolAllocator is null");
        Objects.requireNonNull(idAllocator, "idAllocator is null");
        Objects.requireNonNull(metadata, "metadata is null");
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(approximationConfidence, "approximationConfidence is null");
        this.analysis = analysis;
        this.symbolAllocator = symbolAllocator;
        this.idAllocator = idAllocator;
        this.metadata = metadata;
        this.session = session;
        this.approximationConfidence = approximationConfidence;
        this.subqueryPlanner = new SubqueryPlanner(analysis, symbolAllocator, idAllocator, metadata, session);
    }

    public RelationPlan plan(Query query) {
        PlanBuilder builder = this.planQueryBody(query);
        List<Expression> orderBy = this.analysis.getOrderByExpressions((Node)query);
        builder = this.handleSubqueries(builder, (Node)query, orderBy);
        List<Expression> outputs = this.analysis.getOutputExpressions((Node)query);
        builder = this.handleSubqueries(builder, (Node)query, outputs);
        builder = this.project(builder, Iterables.concat(orderBy, outputs));
        builder = this.sort(builder, query);
        builder = this.project(builder, this.analysis.getOutputExpressions((Node)query));
        builder = this.limit(builder, query);
        return new RelationPlan(builder.getRoot(), this.analysis.getOutputDescriptor((Node)query), this.computeOutputs(builder, this.analysis.getOutputExpressions((Node)query)), builder.getSampleWeight());
    }

    public RelationPlan plan(QuerySpecification node) {
        PlanBuilder builder = this.planFrom(node);
        builder = this.filter(builder, this.analysis.getWhere(node), (Node)node);
        builder = this.aggregate(builder, node);
        builder = this.filter(builder, this.analysis.getHaving(node), (Node)node);
        builder = this.window(builder, node);
        List<Expression> orderBy = this.analysis.getOrderByExpressions((Node)node);
        builder = this.handleSubqueries(builder, (Node)node, orderBy);
        List<Expression> outputs = this.analysis.getOutputExpressions((Node)node);
        builder = this.handleSubqueries(builder, (Node)node, outputs);
        builder = this.project(builder, Iterables.concat(orderBy, outputs));
        builder = this.distinct(builder, node, outputs, orderBy);
        builder = this.sort(builder, node);
        builder = this.project(builder, this.analysis.getOutputExpressions((Node)node));
        builder = this.limit(builder, node);
        return new RelationPlan(builder.getRoot(), this.analysis.getOutputDescriptor((Node)node), this.computeOutputs(builder, this.analysis.getOutputExpressions((Node)node)), builder.getSampleWeight());
    }

    public DeleteNode plan(Delete node) {
        RelationType descriptor = this.analysis.getOutputDescriptor((Node)node.getTable());
        TableHandle handle = this.analysis.getTableHandle(node.getTable());
        ColumnHandle rowIdHandle = this.metadata.getUpdateRowIdColumnHandle(this.session, handle);
        Type rowIdType = this.metadata.getColumnMetadata(this.session, handle, rowIdHandle).getType();
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        ImmutableMap.Builder columns = ImmutableMap.builder();
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Field field : descriptor.getAllFields()) {
            Symbol symbol = this.symbolAllocator.newSymbol(field.getName().get(), field.getType());
            outputSymbols.add((Object)symbol);
            columns.put((Object)symbol, (Object)this.analysis.getColumn(field));
            fields.add((Object)field);
        }
        Field rowIdField = Field.newUnqualified(Optional.empty(), rowIdType);
        Symbol rowIdSymbol = this.symbolAllocator.newSymbol("$rowId", rowIdField.getType());
        outputSymbols.add((Object)rowIdSymbol);
        columns.put((Object)rowIdSymbol, (Object)rowIdHandle);
        fields.add((Object)rowIdField);
        TableScanNode tableScan = new TableScanNode(this.idAllocator.getNextId(), handle, (List<Symbol>)outputSymbols.build(), (Map<Symbol, ColumnHandle>)columns.build(), Optional.empty(), (TupleDomain<ColumnHandle>)TupleDomain.all(), null);
        RelationPlan relationPlan = new RelationPlan(tableScan, new RelationType((List<Field>)fields.build()), (List<Symbol>)outputSymbols.build(), Optional.empty());
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        PlanBuilder builder = new PlanBuilder(translations, relationPlan.getRoot(), relationPlan.getSampleWeight());
        if (node.getWhere().isPresent()) {
            builder = this.filter(builder, (Expression)node.getWhere().get(), (Node)node);
        }
        Symbol rowId = builder.translate((Expression)new FieldReference(relationPlan.getDescriptor().indexOf(rowIdField)));
        ImmutableList outputs = ImmutableList.of((Object)this.symbolAllocator.newSymbol("partialrows", (Type)BigintType.BIGINT), (Object)this.symbolAllocator.newSymbol("fragment", (Type)VarbinaryType.VARBINARY));
        return new DeleteNode(this.idAllocator.getNextId(), builder.getRoot(), new TableWriterNode.DeleteHandle(handle), rowId, (List<Symbol>)outputs);
    }

    private List<Symbol> computeOutputs(PlanBuilder builder, List<Expression> outputExpressions) {
        ImmutableList.Builder outputSymbols = ImmutableList.builder();
        for (Expression expression : outputExpressions) {
            outputSymbols.add((Object)builder.translate(expression));
        }
        return outputSymbols.build();
    }

    private PlanBuilder planQueryBody(Query query) {
        RelationPlan relationPlan = (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)query.getQueryBody(), null);
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot(), relationPlan.getSampleWeight());
    }

    private PlanBuilder planFrom(QuerySpecification node) {
        RelationPlan relationPlan = node.getFrom().isPresent() ? (RelationPlan)new RelationPlanner(this.analysis, this.symbolAllocator, this.idAllocator, this.metadata, this.session).process((Node)node.getFrom().get(), null) : this.planImplicitTable();
        TranslationMap translations = new TranslationMap(relationPlan, this.analysis);
        translations.setFieldMappings(relationPlan.getOutputSymbols());
        return new PlanBuilder(translations, relationPlan.getRoot(), relationPlan.getSampleWeight());
    }

    private RelationPlan planImplicitTable() {
        ImmutableList emptyRow = ImmutableList.of();
        return new RelationPlan(new ValuesNode(this.idAllocator.getNextId(), (List<Symbol>)ImmutableList.of(), (List<List<Expression>>)ImmutableList.of((Object)emptyRow)), new RelationType(new Field[0]), (List<Symbol>)ImmutableList.of(), Optional.empty());
    }

    private PlanBuilder filter(PlanBuilder subPlan, Expression predicate, Node node) {
        if (predicate == null) {
            return subPlan;
        }
        Expression rewrittenBeforeSubqueries = subPlan.rewrite(predicate);
        subPlan = this.subqueryPlanner.handleSubqueries(subPlan, rewrittenBeforeSubqueries, node);
        Expression rewrittenAfterSubqueries = subPlan.rewrite(predicate);
        return subPlan.withNewRoot(new FilterNode(this.idAllocator.getNextId(), subPlan.getRoot(), rewrittenAfterSubqueries));
    }

    private PlanBuilder project(PlanBuilder subPlan, Iterable<Expression> expressions) {
        TranslationMap outputTranslations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Symbol symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getTypeWithCoercions(expression));
            projections.put((Object)symbol, (Object)subPlan.rewrite(expression));
            outputTranslations.put(expression, symbol);
        }
        if (subPlan.getSampleWeight().isPresent()) {
            Symbol symbol = subPlan.getSampleWeight().get();
            projections.put((Object)symbol, (Object)symbol.toSymbolReference());
        }
        return new PlanBuilder(outputTranslations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()), subPlan.getSampleWeight());
    }

    private Map<Symbol, Expression> coerce(Iterable<? extends Expression> expressions, PlanBuilder subPlan, TranslationMap translations) {
        ImmutableMap.Builder projections = ImmutableMap.builder();
        for (Expression expression : expressions) {
            Type type = this.analysis.getType(expression);
            Type coercion = this.analysis.getCoercion(expression);
            Symbol symbol = this.symbolAllocator.newSymbol(expression, (Type)MoreObjects.firstNonNull((Object)coercion, (Object)type));
            Expression rewritten = subPlan.rewrite(expression);
            if (coercion != null) {
                rewritten = new Cast(rewritten, coercion.getTypeSignature().toString(), false, this.metadata.getTypeManager().isTypeOnlyCoercion(type, coercion));
            }
            projections.put((Object)symbol, (Object)rewritten);
            translations.put(expression, symbol);
        }
        return projections.build();
    }

    private PlanBuilder explicitCoercionFields(PlanBuilder subPlan, Iterable<Expression> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        ImmutableMap.Builder projections = ImmutableMap.builder();
        projections.putAll(this.coerce(uncoerced, subPlan, translations));
        for (Expression expression : alreadyCoerced) {
            Symbol symbol = this.symbolAllocator.newSymbol(expression, this.analysis.getType(expression));
            Expression rewritten = subPlan.rewrite(expression);
            projections.put((Object)symbol, (Object)rewritten);
            translations.put(expression, symbol);
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()), subPlan.getSampleWeight());
    }

    private PlanBuilder explicitCoercionSymbols(PlanBuilder subPlan, Iterable<Symbol> alreadyCoerced, Iterable<? extends Expression> uncoerced) {
        TranslationMap translations = subPlan.copyTranslations();
        ImmutableMap.Builder projections = ImmutableMap.builder();
        projections.putAll(this.coerce(uncoerced, subPlan, translations));
        for (Symbol symbol : alreadyCoerced) {
            projections.put((Object)symbol, (Object)symbol.toSymbolReference());
        }
        return new PlanBuilder(translations, new ProjectNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Map<Symbol, Expression>)projections.build()), subPlan.getSampleWeight());
    }

    private PlanBuilder aggregate(PlanBuilder subPlan, QuerySpecification node) {
        List<List<Expression>> groupingSets = this.analysis.getGroupingSets(node);
        if (groupingSets.isEmpty()) {
            return subPlan;
        }
        Set distinctGroupingColumns = (Set)groupingSets.stream().flatMap(Collection::stream).collect(ImmutableCollectors.toImmutableSet());
        List arguments = (List)this.analysis.getAggregates(node).stream().map(FunctionCall::getArguments).flatMap(Collection::stream).collect(ImmutableCollectors.toImmutableList());
        Iterable inputs = Iterables.concat((Iterable)distinctGroupingColumns, (Iterable)arguments);
        subPlan = this.handleSubqueries(subPlan, (Node)node, inputs);
        if (!Iterables.isEmpty((Iterable)inputs)) {
            subPlan = this.project(subPlan, inputs);
        }
        TranslationMap translations = new TranslationMap(subPlan.getRelationPlan(), this.analysis);
        ImmutableList.Builder groupingSetsSymbolsBuilder = ImmutableList.builder();
        ImmutableSet.Builder distinctGroupingSymbolsBuilder = ImmutableSet.builder();
        for (List<Expression> groupingSet : groupingSets) {
            ImmutableList.Builder groupingColumns = ImmutableList.builder();
            for (Expression expression : groupingSet) {
                Symbol symbol = subPlan.translate(expression);
                groupingColumns.add((Object)symbol);
                distinctGroupingSymbolsBuilder.add((Object)symbol);
                translations.put(expression, symbol);
            }
            groupingSetsSymbolsBuilder.add((Object)groupingColumns.build());
        }
        ImmutableList groupingSetsSymbols = groupingSetsSymbolsBuilder.build();
        if (groupingSets.size() > 1) {
            ImmutableMap.Builder identityMapping = ImmutableMap.builder();
            for (Expression argument : ImmutableSet.copyOf((Collection)arguments)) {
                Symbol output = this.symbolAllocator.newSymbol(argument, this.analysis.getTypeWithCoercions(argument), "id");
                identityMapping.put((Object)subPlan.translate(argument), (Object)output);
                subPlan.getTranslations().put(argument, output);
            }
            Symbol groupIdSymbol = this.symbolAllocator.newSymbol("groupId", (Type)BigintType.BIGINT);
            GroupIdNode groupId = new GroupIdNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<List<Symbol>>)groupingSetsSymbols, (Map<Symbol, Symbol>)identityMapping.build(), groupIdSymbol);
            subPlan = subPlan.withNewRoot(groupId);
            distinctGroupingSymbolsBuilder.add((Object)groupIdSymbol);
        }
        ImmutableMap.Builder aggregationAssignments = ImmutableMap.builder();
        ImmutableMap.Builder functions = ImmutableMap.builder();
        boolean needPostProjectionCoercion = false;
        for (FunctionCall aggregate : this.analysis.getAggregates(node)) {
            Object rewritten = subPlan.rewrite((Expression)aggregate);
            Symbol newSymbol = this.symbolAllocator.newSymbol((Expression)rewritten, this.analysis.getType((Expression)aggregate));
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
                needPostProjectionCoercion = true;
            }
            aggregationAssignments.put((Object)newSymbol, (Object)((FunctionCall)rewritten));
            translations.put((Expression)aggregate, newSymbol);
            functions.put((Object)newSymbol, (Object)this.analysis.getFunctionSignature(aggregate));
        }
        HashMap<ImmutableSet, Symbol> argumentMarkers = new HashMap<ImmutableSet, Symbol>();
        HashMap<Symbol, Symbol> masks = new HashMap<Symbol, Symbol>();
        for (Object aggregate : Iterables.filter(this.analysis.getAggregates(node), FunctionCall::isDistinct)) {
            ImmutableSet immutableSet = ImmutableSet.copyOf((Collection)aggregate.getArguments());
            Symbol marker = (Symbol)argumentMarkers.get(immutableSet);
            Symbol aggregateSymbol = translations.get((Expression)aggregate);
            if (marker == null) {
                marker = immutableSet.size() == 1 ? this.symbolAllocator.newSymbol((Expression)Iterables.getOnlyElement((Iterable)immutableSet), (Type)BooleanType.BOOLEAN, "distinct") : this.symbolAllocator.newSymbol(aggregateSymbol.getName(), (Type)BooleanType.BOOLEAN, "distinct");
                argumentMarkers.put(immutableSet, marker);
            }
            masks.put(aggregateSymbol, marker);
        }
        ImmutableList distinctGroupingSymbols = distinctGroupingSymbolsBuilder.build().asList();
        for (Map.Entry entry : argumentMarkers.entrySet()) {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)distinctGroupingSymbols);
            for (Expression expression : (Set)entry.getKey()) {
                builder.add((Object)subPlan.translate(expression));
            }
            subPlan = subPlan.withNewRoot(new MarkDistinctNode(this.idAllocator.getNextId(), subPlan.getRoot(), (Symbol)entry.getValue(), (List<Symbol>)builder.build(), Optional.empty()));
        }
        double confidence = this.approximationConfidence.orElse(1.0);
        AggregationNode aggregationNode = new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<Symbol>)distinctGroupingSymbols, (Map<Symbol, FunctionCall>)aggregationAssignments.build(), (Map<Symbol, Signature>)functions.build(), masks, (List<List<Symbol>>)groupingSetsSymbols, AggregationNode.Step.SINGLE, subPlan.getSampleWeight(), confidence, Optional.empty());
        subPlan = new PlanBuilder(translations, aggregationNode, Optional.empty());
        if (needPostProjectionCoercion) {
            return this.explicitCoercionFields(subPlan, distinctGroupingColumns, this.analysis.getAggregates(node));
        }
        return subPlan;
    }

    private PlanBuilder window(PlanBuilder subPlan, QuerySpecification node) {
        ImmutableSet windowFunctions = ImmutableSet.copyOf(this.analysis.getWindowFunctions(node));
        if (windowFunctions.isEmpty()) {
            return subPlan;
        }
        for (FunctionCall windowFunction : windowFunctions) {
            Object expression2;
            Window window = (Window)windowFunction.getWindow().get();
            WindowFrame.Type frameType = WindowFrame.Type.RANGE;
            FrameBound.Type frameStartType = FrameBound.Type.UNBOUNDED_PRECEDING;
            FrameBound.Type frameEndType = FrameBound.Type.CURRENT_ROW;
            Expression frameStart = null;
            Expression frameEnd = null;
            if (window.getFrame().isPresent()) {
                WindowFrame frame = (WindowFrame)window.getFrame().get();
                frameType = frame.getType();
                frameStartType = frame.getStart().getType();
                frameStart = frame.getStart().getValue().orElse(null);
                if (frame.getEnd().isPresent()) {
                    frameEndType = ((FrameBound)frame.getEnd().get()).getType();
                    frameEnd = ((FrameBound)frame.getEnd().get()).getValue().orElse(null);
                }
            }
            ImmutableList.Builder inputs = ImmutableList.builder().addAll((Iterable)windowFunction.getArguments()).addAll((Iterable)window.getPartitionBy()).addAll(Iterables.transform((Iterable)window.getOrderBy(), SortItem::getSortKey));
            if (frameStart != null) {
                inputs.add(frameStart);
            }
            if (frameEnd != null) {
                inputs.add(frameEnd);
            }
            subPlan = subPlan.appendProjections((Iterable<Expression>)inputs.build(), this.symbolAllocator, this.idAllocator);
            ImmutableList.Builder partitionBySymbols = ImmutableList.builder();
            for (Object expression2 : window.getPartitionBy()) {
                partitionBySymbols.add((Object)subPlan.translate((Expression)expression2));
            }
            LinkedHashMap<Symbol, SortOrder> orderings = new LinkedHashMap<Symbol, SortOrder>();
            expression2 = window.getOrderBy().iterator();
            while (expression2.hasNext()) {
                SortItem item = (SortItem)expression2.next();
                Symbol symbol = subPlan.translate(item.getSortKey());
                orderings.put(symbol, this.toSortOrder(item));
            }
            Optional<Symbol> frameStartSymbol = Optional.empty();
            Optional<Symbol> frameEndSymbol = Optional.empty();
            if (frameStart != null) {
                frameStartSymbol = Optional.of(subPlan.translate(frameStart));
            }
            if (frameEnd != null) {
                frameEndSymbol = Optional.of(subPlan.translate(frameEnd));
            }
            WindowNode.Frame frame = new WindowNode.Frame(frameType, frameStartType, frameStartSymbol, frameEndType, frameEndSymbol);
            TranslationMap outputTranslations = subPlan.copyTranslations();
            ImmutableMap.Builder assignments = ImmutableMap.builder();
            HashMap<Symbol, Signature> signatures = new HashMap<Symbol, Signature>();
            Expression rewritten = subPlan.rewrite((Expression)windowFunction);
            Symbol newSymbol = this.symbolAllocator.newSymbol(rewritten, this.analysis.getType((Expression)windowFunction));
            boolean needCoercion = rewritten instanceof Cast;
            if (rewritten instanceof Cast) {
                rewritten = ((Cast)rewritten).getExpression();
            }
            assignments.put((Object)newSymbol, (Object)((FunctionCall)rewritten));
            outputTranslations.put((Expression)windowFunction, newSymbol);
            signatures.put(newSymbol, this.analysis.getFunctionSignature(windowFunction));
            List<Symbol> sourceSymbols = subPlan.getRoot().getOutputSymbols();
            ImmutableList.Builder orderBySymbols = ImmutableList.builder();
            orderBySymbols.addAll(orderings.keySet());
            subPlan = new PlanBuilder(outputTranslations, new WindowNode(this.idAllocator.getNextId(), subPlan.getRoot(), new WindowNode.Specification((List<Symbol>)partitionBySymbols.build(), (List<Symbol>)orderBySymbols.build(), orderings, frame), (Map<Symbol, FunctionCall>)assignments.build(), signatures, Optional.empty(), (Set<Symbol>)ImmutableSet.of(), 0), subPlan.getSampleWeight());
            if (!needCoercion) continue;
            subPlan = this.explicitCoercionSymbols(subPlan, sourceSymbols, (Iterable<? extends Expression>)ImmutableList.of((Object)windowFunction));
        }
        return subPlan;
    }

    private PlanBuilder handleSubqueries(PlanBuilder subPlan, Node node, Iterable<Expression> inputs) {
        for (Expression input : inputs) {
            Expression rewritten = subPlan.rewrite(input);
            subPlan = this.subqueryPlanner.handleSubqueries(subPlan, rewritten, node);
        }
        return subPlan;
    }

    private PlanBuilder distinct(PlanBuilder subPlan, QuerySpecification node, List<Expression> outputs, List<Expression> orderBy) {
        if (node.getSelect().isDistinct()) {
            Preconditions.checkState((boolean)outputs.containsAll(orderBy), (Object)"Expected ORDER BY terms to be in SELECT. Broken analysis");
            return subPlan.withNewRoot(new AggregationNode(this.idAllocator.getNextId(), subPlan.getRoot(), subPlan.getRoot().getOutputSymbols(), (Map<Symbol, FunctionCall>)ImmutableMap.of(), (Map<Symbol, Signature>)ImmutableMap.of(), (Map<Symbol, Symbol>)ImmutableMap.of(), (List<List<Symbol>>)ImmutableList.of(subPlan.getRoot().getOutputSymbols()), AggregationNode.Step.SINGLE, Optional.empty(), 1.0, Optional.empty()));
        }
        return subPlan;
    }

    private PlanBuilder sort(PlanBuilder subPlan, Query node) {
        return this.sort(subPlan, node.getOrderBy(), node.getLimit(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, QuerySpecification node) {
        return this.sort(subPlan, node.getOrderBy(), node.getLimit(), this.analysis.getOrderByExpressions((Node)node));
    }

    private PlanBuilder sort(PlanBuilder subPlan, List<SortItem> orderBy, Optional<String> limit, List<Expression> orderByExpressions) {
        if (orderBy.isEmpty()) {
            return subPlan;
        }
        Iterator<SortItem> sortItems = orderBy.iterator();
        ImmutableList.Builder orderBySymbols = ImmutableList.builder();
        HashMap<Symbol, SortOrder> orderings = new HashMap<Symbol, SortOrder>();
        for (Expression fieldOrExpression : orderByExpressions) {
            Symbol symbol = subPlan.translate(fieldOrExpression);
            SortItem sortItem = sortItems.next();
            if (orderings.containsKey(symbol)) continue;
            orderBySymbols.add((Object)symbol);
            orderings.put(symbol, this.toSortOrder(sortItem));
        }
        PlanNode planNode = limit.isPresent() && !limit.get().equalsIgnoreCase("all") ? new TopNNode(this.idAllocator.getNextId(), subPlan.getRoot(), Long.parseLong(limit.get()), (List<Symbol>)orderBySymbols.build(), orderings, false) : new SortNode(this.idAllocator.getNextId(), subPlan.getRoot(), (List<Symbol>)orderBySymbols.build(), orderings);
        return subPlan.withNewRoot(planNode);
    }

    private PlanBuilder limit(PlanBuilder subPlan, Query node) {
        return this.limit(subPlan, node.getOrderBy(), node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, QuerySpecification node) {
        return this.limit(subPlan, node.getOrderBy(), node.getLimit());
    }

    private PlanBuilder limit(PlanBuilder subPlan, List<SortItem> orderBy, Optional<String> limit) {
        if (orderBy.isEmpty() && limit.isPresent() && !limit.get().equalsIgnoreCase("all")) {
            long limitValue = Long.parseLong(limit.get());
            subPlan = subPlan.withNewRoot(new LimitNode(this.idAllocator.getNextId(), subPlan.getRoot(), limitValue, false));
        }
        return subPlan;
    }

    private SortOrder toSortOrder(SortItem sortItem) {
        if (sortItem.getOrdering() == SortItem.Ordering.ASCENDING) {
            if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
                return SortOrder.ASC_NULLS_FIRST;
            }
            return SortOrder.ASC_NULLS_LAST;
        }
        if (sortItem.getNullOrdering() == SortItem.NullOrdering.FIRST) {
            return SortOrder.DESC_NULLS_FIRST;
        }
        return SortOrder.DESC_NULLS_LAST;
    }
}

