/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class ExpressionExtractor
extends SimplePlanVisitor<ImmutableList.Builder<Expression>> {
    public static List<Expression> extractExpressions(PlanNode plan) {
        ImmutableList.Builder expressionsBuilder = ImmutableList.builder();
        plan.accept(new ExpressionExtractor(), expressionsBuilder);
        return expressionsBuilder.build();
    }

    @Override
    public Void visitFilter(FilterNode node, ImmutableList.Builder<Expression> context) {
        context.add((Object)node.getPredicate());
        return (Void)super.visitFilter(node, context);
    }

    @Override
    public Void visitProject(ProjectNode node, ImmutableList.Builder<Expression> context) {
        context.addAll(node.getAssignments().values());
        return (Void)super.visitProject(node, context);
    }

    @Override
    public Void visitTableScan(TableScanNode node, ImmutableList.Builder<Expression> context) {
        if (node.getOriginalConstraint() != null) {
            context.add((Object)node.getOriginalConstraint());
        }
        return (Void)super.visitTableScan(node, context);
    }

    @Override
    public Void visitValues(ValuesNode node, ImmutableList.Builder<Expression> context) {
        node.getRows().forEach(arg_0 -> context.addAll(arg_0));
        return (Void)super.visitValues(node, context);
    }
}

