/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.RegexLibrary;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class FeaturesConfig {
    public static final String FILE_BASED_RESOURCE_GROUP_MANAGER = "file";
    private boolean experimentalSyntaxEnabled;
    private boolean distributedIndexJoinsEnabled;
    private boolean distributedJoinsEnabled = true;
    private boolean colocatedJoinsEnabled;
    private boolean redistributeWrites = true;
    private boolean optimizeMetadataQueries;
    private boolean optimizeHashGeneration = true;
    private boolean optimizeSingleDistinct = true;
    private boolean pushTableWriteThroughUnion = true;
    private String processingOptimization = "disabled";
    private boolean dictionaryAggregation;
    private boolean resourceGroups;
    private String resourceGroupManager = "file";
    private int re2JDfaStatesLimit = Integer.MAX_VALUE;
    private int re2JDfaRetries = 5;
    private RegexLibrary regexLibrary = RegexLibrary.JONI;

    @NotNull
    public String getResourceGroupManager() {
        return this.resourceGroupManager;
    }

    @Config(value="resource-group-manager")
    public FeaturesConfig setResourceGroupManager(String resourceGroupManager) {
        this.resourceGroupManager = resourceGroupManager;
        return this;
    }

    public boolean isResourceGroupsEnabled() {
        return this.resourceGroups;
    }

    @Config(value="experimental.resource-groups-enabled")
    public FeaturesConfig setResourceGroupsEnabled(boolean enabled) {
        this.resourceGroups = enabled;
        return this;
    }

    public boolean isExperimentalSyntaxEnabled() {
        return this.experimentalSyntaxEnabled;
    }

    @LegacyConfig(value={"analyzer.experimental-syntax-enabled"})
    @Config(value="experimental-syntax-enabled")
    public FeaturesConfig setExperimentalSyntaxEnabled(boolean enabled) {
        this.experimentalSyntaxEnabled = enabled;
        return this;
    }

    public boolean isDistributedIndexJoinsEnabled() {
        return this.distributedIndexJoinsEnabled;
    }

    @Config(value="distributed-index-joins-enabled")
    public FeaturesConfig setDistributedIndexJoinsEnabled(boolean distributedIndexJoinsEnabled) {
        this.distributedIndexJoinsEnabled = distributedIndexJoinsEnabled;
        return this;
    }

    public boolean isDistributedJoinsEnabled() {
        return this.distributedJoinsEnabled;
    }

    @Config(value="distributed-joins-enabled")
    public FeaturesConfig setDistributedJoinsEnabled(boolean distributedJoinsEnabled) {
        this.distributedJoinsEnabled = distributedJoinsEnabled;
        return this;
    }

    public boolean isColocatedJoinsEnabled() {
        return this.colocatedJoinsEnabled;
    }

    @Config(value="colocated-joins-enabled")
    @ConfigDescription(value="Experimental: Use a colocated join when possible")
    public FeaturesConfig setColocatedJoinsEnabled(boolean colocatedJoinsEnabled) {
        this.colocatedJoinsEnabled = colocatedJoinsEnabled;
        return this;
    }

    public boolean isRedistributeWrites() {
        return this.redistributeWrites;
    }

    @Config(value="redistribute-writes")
    public FeaturesConfig setRedistributeWrites(boolean redistributeWrites) {
        this.redistributeWrites = redistributeWrites;
        return this;
    }

    public boolean isOptimizeMetadataQueries() {
        return this.optimizeMetadataQueries;
    }

    @Config(value="optimizer.optimize-metadata-queries")
    public FeaturesConfig setOptimizeMetadataQueries(boolean optimizeMetadataQueries) {
        this.optimizeMetadataQueries = optimizeMetadataQueries;
        return this;
    }

    public boolean isOptimizeHashGeneration() {
        return this.optimizeHashGeneration;
    }

    @Config(value="optimizer.optimize-hash-generation")
    public FeaturesConfig setOptimizeHashGeneration(boolean optimizeHashGeneration) {
        this.optimizeHashGeneration = optimizeHashGeneration;
        return this;
    }

    public boolean isOptimizeSingleDistinct() {
        return this.optimizeSingleDistinct;
    }

    @Config(value="optimizer.optimize-single-distinct")
    public FeaturesConfig setOptimizeSingleDistinct(boolean optimizeSingleDistinct) {
        this.optimizeSingleDistinct = optimizeSingleDistinct;
        return this;
    }

    public boolean isPushTableWriteThroughUnion() {
        return this.pushTableWriteThroughUnion;
    }

    @Config(value="optimizer.push-table-write-through-union")
    public FeaturesConfig setPushTableWriteThroughUnion(boolean pushTableWriteThroughUnion) {
        this.pushTableWriteThroughUnion = pushTableWriteThroughUnion;
        return this;
    }

    public String getProcessingOptimization() {
        return this.processingOptimization;
    }

    @Config(value="optimizer.processing-optimization")
    public FeaturesConfig setProcessingOptimization(String processingOptimization) {
        if (!ProcessingOptimization.AVAILABLE_OPTIONS.contains(processingOptimization)) {
            throw new IllegalStateException(String.format("Value %s is not valid for processingOptimization.", processingOptimization));
        }
        this.processingOptimization = processingOptimization;
        return this;
    }

    public boolean isDictionaryAggregation() {
        return this.dictionaryAggregation;
    }

    @Config(value="optimizer.dictionary-aggregation")
    public FeaturesConfig setDictionaryAggregation(boolean dictionaryAggregation) {
        this.dictionaryAggregation = dictionaryAggregation;
        return this;
    }

    @Min(value=2L)
    public int getRe2JDfaStatesLimit() {
        return this.re2JDfaStatesLimit;
    }

    @Config(value="re2j.dfa-states-limit")
    public FeaturesConfig setRe2JDfaStatesLimit(int re2JDfaStatesLimit) {
        this.re2JDfaStatesLimit = re2JDfaStatesLimit;
        return this;
    }

    @Min(value=0L)
    public int getRe2JDfaRetries() {
        return this.re2JDfaRetries;
    }

    @Config(value="re2j.dfa-retries")
    public FeaturesConfig setRe2JDfaRetries(int re2JDfaRetries) {
        this.re2JDfaRetries = re2JDfaRetries;
        return this;
    }

    public RegexLibrary getRegexLibrary() {
        return this.regexLibrary;
    }

    @Config(value="regex-library")
    public FeaturesConfig setRegexLibrary(RegexLibrary regexLibrary) {
        this.regexLibrary = regexLibrary;
        return this;
    }

    public static class ProcessingOptimization {
        public static final String DISABLED = "disabled";
        public static final String COLUMNAR = "columnar";
        public static final String COLUMNAR_DICTIONARY = "columnar_dictionary";
        public static final List<String> AVAILABLE_OPTIONS = ImmutableList.of((Object)"disabled", (Object)"columnar", (Object)"columnar_dictionary");
    }
}

