/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.InPredicate;
import com.facebook.presto.sql.tree.SubqueryExpression;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;

public class ExpressionAnalysis {
    private final IdentityHashMap<Expression, Type> expressionTypes;
    private final IdentityHashMap<Expression, Type> expressionCoercions;
    private final Set<Expression> typeOnlyCoercions;
    private final Set<InPredicate> subqueryInPredicates;
    private final Set<Expression> columnReferences;
    private final Set<SubqueryExpression> scalarSubqueries;

    public ExpressionAnalysis(IdentityHashMap<Expression, Type> expressionTypes, IdentityHashMap<Expression, Type> expressionCoercions, Set<InPredicate> subqueryInPredicates, Set<SubqueryExpression> scalarSubqueries, Set<Expression> columnReferences, Set<Expression> typeOnlyCoercions) {
        this.expressionTypes = Objects.requireNonNull(expressionTypes, "expressionTypes is null");
        this.expressionCoercions = Objects.requireNonNull(expressionCoercions, "expressionCoercions is null");
        this.typeOnlyCoercions = Objects.requireNonNull(typeOnlyCoercions, "typeOnlyCoercions is null");
        this.subqueryInPredicates = Objects.requireNonNull(subqueryInPredicates, "subqueryInPredicates is null");
        this.scalarSubqueries = Objects.requireNonNull(scalarSubqueries, "subqueryInPredicates is null");
        this.columnReferences = ImmutableSet.copyOf((Collection)Objects.requireNonNull(columnReferences, "columnReferences is null"));
    }

    public Type getType(Expression expression) {
        return this.expressionTypes.get(expression);
    }

    public IdentityHashMap<Expression, Type> getExpressionTypes() {
        return this.expressionTypes;
    }

    public Type getCoercion(Expression expression) {
        return this.expressionCoercions.get(expression);
    }

    public boolean isTypeOnlyCoercion(Expression expression) {
        return this.typeOnlyCoercions.contains(expression);
    }

    public Set<InPredicate> getSubqueryInPredicates() {
        return this.subqueryInPredicates;
    }

    public Set<SubqueryExpression> getScalarSubqueries() {
        return this.scalarSubqueries;
    }

    public Set<Expression> getColumnReferences() {
        return this.columnReferences;
    }
}

