/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.tree.WithQuery;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class AnalysisContext {
    private final Optional<AnalysisContext> parent;
    private final RelationType parentRelationType;
    private final Map<String, WithQuery> namedQueries = new HashMap<String, WithQuery>();
    private RelationType lateralTupleDescriptor = new RelationType(new Field[0]);
    private boolean approximate;

    public AnalysisContext(AnalysisContext parent, RelationType parentRelationType) {
        this.parent = Optional.of(parent);
        this.parentRelationType = Objects.requireNonNull(parentRelationType, "parentRelationType is null");
        this.approximate = parent.approximate;
    }

    public AnalysisContext() {
        this.parent = Optional.empty();
        this.parentRelationType = new RelationType(new Field[0]);
    }

    public void setLateralTupleDescriptor(RelationType lateralTupleDescriptor) {
        this.lateralTupleDescriptor = lateralTupleDescriptor;
    }

    public RelationType getLateralTupleDescriptor() {
        return this.lateralTupleDescriptor;
    }

    public boolean isApproximate() {
        return this.approximate;
    }

    public void setApproximate(boolean approximate) {
        this.approximate = approximate;
    }

    public void addNamedQuery(String name, WithQuery withQuery) {
        Preconditions.checkState((!this.namedQueries.containsKey(name) ? 1 : 0) != 0, (String)"Named query already registered: %s", (Object[])new Object[]{name});
        this.namedQueries.put(name, withQuery);
    }

    public WithQuery getNamedQuery(String name) {
        WithQuery result = this.namedQueries.get(name);
        if (result == null && this.parent.isPresent()) {
            return this.parent.get().getNamedQuery(name);
        }
        return result;
    }

    public boolean isNamedQueryDeclared(String name) {
        return this.namedQueries.containsKey(name);
    }

    public RelationType getParentRelationType() {
        return this.parentRelationType;
    }

    public Optional<AnalysisContext> getParent() {
        return this.parent;
    }
}

