/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;

public final class SqlFormatterUtil {
    private SqlFormatterUtil() {
    }

    public static String getFormattedSql(Statement statement, SqlParser sqlParser) {
        Statement parsed;
        String sql = SqlFormatter.formatSql((Node)statement);
        try {
            parsed = sqlParser.createStatement(sql);
        }
        catch (ParsingException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Formatted query does not parse: " + statement);
        }
        if (!statement.equals((Object)parsed)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Query does not round-trip: " + statement);
        }
        return sql;
    }
}

