/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.IsNullPredicate;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.NotExpression;
import com.facebook.presto.sql.tree.QualifiedNameReference;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ExpressionUtils {
    private ExpressionUtils() {
    }

    public static List<Expression> extractConjuncts(Expression expression) {
        return ExpressionUtils.extractPredicates(LogicalBinaryExpression.Type.AND, expression);
    }

    public static List<Expression> extractDisjuncts(Expression expression) {
        return ExpressionUtils.extractPredicates(LogicalBinaryExpression.Type.OR, expression);
    }

    public static List<Expression> extractPredicates(LogicalBinaryExpression expression) {
        return ExpressionUtils.extractPredicates(expression.getType(), (Expression)expression);
    }

    public static List<Expression> extractPredicates(LogicalBinaryExpression.Type type, Expression expression) {
        if (expression instanceof LogicalBinaryExpression && ((LogicalBinaryExpression)expression).getType() == type) {
            LogicalBinaryExpression logicalBinaryExpression = (LogicalBinaryExpression)expression;
            return ImmutableList.builder().addAll(ExpressionUtils.extractPredicates(type, logicalBinaryExpression.getLeft())).addAll(ExpressionUtils.extractPredicates(type, logicalBinaryExpression.getRight())).build();
        }
        return ImmutableList.of((Object)expression);
    }

    public static Expression and(Expression ... expressions) {
        return ExpressionUtils.and(Arrays.asList(expressions));
    }

    public static Expression and(Collection<Expression> expressions) {
        return ExpressionUtils.binaryExpression(LogicalBinaryExpression.Type.AND, expressions);
    }

    public static Expression or(Expression ... expressions) {
        return ExpressionUtils.or(Arrays.asList(expressions));
    }

    public static Expression or(Collection<Expression> expressions) {
        return ExpressionUtils.binaryExpression(LogicalBinaryExpression.Type.OR, expressions);
    }

    public static Expression binaryExpression(LogicalBinaryExpression.Type type, Collection<Expression> expressions) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(expressions, "expressions is null");
        Preconditions.checkArgument((!expressions.isEmpty() ? 1 : 0) != 0, (Object)"expressions is empty");
        ArrayDeque<Expression> queue = new ArrayDeque<Expression>(expressions);
        while (queue.size() > 1) {
            queue.add((Expression)new LogicalBinaryExpression(type, (Expression)queue.remove(), (Expression)queue.remove()));
        }
        return (Expression)queue.remove();
    }

    public static Expression combinePredicates(LogicalBinaryExpression.Type type, Expression ... expressions) {
        return ExpressionUtils.combinePredicates(type, Arrays.asList(expressions));
    }

    public static Expression combinePredicates(LogicalBinaryExpression.Type type, Collection<Expression> expressions) {
        if (type == LogicalBinaryExpression.Type.AND) {
            return ExpressionUtils.combineConjuncts(expressions);
        }
        return ExpressionUtils.combineDisjuncts(expressions);
    }

    public static Expression combineConjuncts(Expression ... expressions) {
        return ExpressionUtils.combineConjuncts(Arrays.asList(expressions));
    }

    public static Expression combineConjuncts(Collection<Expression> expressions) {
        return ExpressionUtils.combineConjunctsWithDefault(expressions, (Expression)BooleanLiteral.TRUE_LITERAL);
    }

    public static Expression combineConjunctsWithDefault(Collection<Expression> expressions, Expression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> conjuncts = expressions.stream().flatMap(e -> ExpressionUtils.extractConjuncts(e).stream()).filter(e -> !e.equals((Object)BooleanLiteral.TRUE_LITERAL)).collect(Collectors.toList());
        conjuncts = ExpressionUtils.removeDuplicates(conjuncts);
        if (conjuncts.contains(BooleanLiteral.FALSE_LITERAL)) {
            return BooleanLiteral.FALSE_LITERAL;
        }
        return conjuncts.isEmpty() ? emptyDefault : ExpressionUtils.and(conjuncts);
    }

    public static Expression combineDisjuncts(Expression ... expressions) {
        return ExpressionUtils.combineDisjuncts(Arrays.asList(expressions));
    }

    public static Expression combineDisjuncts(Collection<Expression> expressions) {
        return ExpressionUtils.combineDisjunctsWithDefault(expressions, (Expression)BooleanLiteral.FALSE_LITERAL);
    }

    public static Expression combineDisjunctsWithDefault(Collection<Expression> expressions, Expression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<Expression> disjuncts = expressions.stream().flatMap(e -> ExpressionUtils.extractDisjuncts(e).stream()).filter(e -> !e.equals((Object)BooleanLiteral.FALSE_LITERAL)).collect(Collectors.toList());
        disjuncts = ExpressionUtils.removeDuplicates(disjuncts);
        if (disjuncts.contains(BooleanLiteral.TRUE_LITERAL)) {
            return BooleanLiteral.TRUE_LITERAL;
        }
        return disjuncts.isEmpty() ? emptyDefault : ExpressionUtils.or(disjuncts);
    }

    public static Expression stripNonDeterministicConjuncts(Expression expression) {
        Set<Expression> conjuncts = ExpressionUtils.extractConjuncts(expression).stream().filter(DeterminismEvaluator::isDeterministic).collect(Collectors.toSet());
        return ExpressionUtils.combineConjuncts(conjuncts);
    }

    public static Expression stripDeterministicConjuncts(Expression expression) {
        return ExpressionUtils.combineConjuncts((Collection)ExpressionUtils.extractConjuncts(expression).stream().filter(conjunct -> !DeterminismEvaluator.isDeterministic(conjunct)).collect(ImmutableCollectors.toImmutableList()));
    }

    public static Function<Expression, Expression> expressionOrNullSymbols(Predicate<Symbol> ... nullSymbolScopes) {
        return expression -> {
            ImmutableList.Builder resultDisjunct = ImmutableList.builder();
            resultDisjunct.add(expression);
            for (Predicate nullSymbolScope : nullSymbolScopes) {
                List symbols = (List)DependencyExtractor.extractUnique(expression).stream().filter(nullSymbolScope).collect(ImmutableCollectors.toImmutableList());
                if (Iterables.isEmpty((Iterable)symbols)) continue;
                ImmutableList.Builder nullConjuncts = ImmutableList.builder();
                for (Symbol symbol : symbols) {
                    nullConjuncts.add((Object)new IsNullPredicate((Expression)symbol.toSymbolReference()));
                }
                resultDisjunct.add((Object)ExpressionUtils.and((Collection<Expression>)nullConjuncts.build()));
            }
            return ExpressionUtils.or((Collection<Expression>)resultDisjunct.build());
        };
    }

    private static List<Expression> removeDuplicates(List<Expression> expressions) {
        List nonDeterministicDisjuncts = (List)expressions.stream().filter(e -> !DeterminismEvaluator.isDeterministic(e)).collect(ImmutableCollectors.toImmutableList());
        Set deterministicDisjuncts = (Set)expressions.stream().filter(DeterminismEvaluator::isDeterministic).collect(ImmutableCollectors.toImmutableSet());
        return ImmutableList.builder().addAll((Iterable)nonDeterministicDisjuncts).addAll((Iterable)deterministicDisjuncts).build();
    }

    public static Expression normalize(Expression expression) {
        if (expression instanceof NotExpression) {
            NotExpression not = (NotExpression)expression;
            if (not.getValue() instanceof ComparisonExpression && ((ComparisonExpression)not.getValue()).getType() != ComparisonExpression.Type.IS_DISTINCT_FROM) {
                ComparisonExpression comparison = (ComparisonExpression)not.getValue();
                return new ComparisonExpression(comparison.getType().negate(), comparison.getLeft(), comparison.getRight());
            }
            if (not.getValue() instanceof NotExpression) {
                return ExpressionUtils.normalize(((NotExpression)not.getValue()).getValue());
            }
        }
        return expression;
    }

    public static Expression rewriteQualifiedNamesToSymbolReferences(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteQualifiedNameReference(QualifiedNameReference node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                return new SymbolReference(node.getName().toString());
            }
        }, (Expression)expression);
    }
}

