/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.remotetask;

import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.server.remotetask.RemoteTaskStats;
import com.facebook.presto.server.remotetask.RequestErrorTracker;
import com.facebook.presto.server.remotetask.SimpleHttpResponseCallback;
import com.facebook.presto.server.remotetask.SimpleHttpResponseHandler;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.SetThreadName;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.concurrent.GuardedBy;

public class TaskInfoFetcher
implements SimpleHttpResponseCallback<TaskInfo> {
    private static final Logger log = Logger.get(TaskInfoFetcher.class);
    private final TaskId taskId;
    private final Consumer<Throwable> onFail;
    private final StateMachine<TaskInfo> taskInfo;
    private final JsonCodec<TaskInfo> taskInfoCodec;
    private final long updateIntervalMillis;
    private final AtomicLong lastUpdateNanos = new AtomicLong();
    private final ScheduledExecutorService updateScheduledExecutor;
    private final Executor executor;
    private final HttpClient httpClient;
    private final RequestErrorTracker errorTracker;
    private final boolean summarizeTaskInfo;
    @GuardedBy(value="this")
    private final AtomicLong currentRequestStartNanos = new AtomicLong();
    @GuardedBy(value="this")
    private final AtomicReference<TaskStatus> taskStatusDone = new AtomicReference();
    @GuardedBy(value="this")
    private final AtomicBoolean lastRequest = new AtomicBoolean();
    private final RemoteTaskStats stats;
    @GuardedBy(value="this")
    private boolean running;
    @GuardedBy(value="this")
    private ScheduledFuture<?> scheduledFuture;
    @GuardedBy(value="this")
    private ListenableFuture<FullJsonResponseHandler.JsonResponse<TaskInfo>> future;

    public TaskInfoFetcher(Consumer<Throwable> onFail, TaskInfo initialTask, HttpClient httpClient, Duration updateInterval, JsonCodec<TaskInfo> taskInfoCodec, Duration minErrorDuration, boolean summarizeTaskInfo, Executor executor, ScheduledExecutorService updateScheduledExecutor, ScheduledExecutorService errorScheduledExecutor, RemoteTaskStats stats) {
        Objects.requireNonNull(initialTask, "initialTask is null");
        Objects.requireNonNull(minErrorDuration, "minErrorDuration is null");
        Objects.requireNonNull(errorScheduledExecutor, "errorScheduledExecutor is null");
        this.taskId = initialTask.getTaskStatus().getTaskId();
        this.onFail = Objects.requireNonNull(onFail, "onFail is null");
        this.taskInfo = new StateMachine<TaskInfo>("task " + this.taskId, executor, initialTask);
        this.taskInfoCodec = Objects.requireNonNull(taskInfoCodec, "taskInfoCodec is null");
        this.updateIntervalMillis = Objects.requireNonNull(updateInterval, "updateInterval is null").toMillis();
        this.updateScheduledExecutor = Objects.requireNonNull(updateScheduledExecutor, "updateScheduledExecutor is null");
        this.errorTracker = new RequestErrorTracker(this.taskId, initialTask.getTaskStatus().getSelf(), minErrorDuration, errorScheduledExecutor, "getting info for task");
        this.summarizeTaskInfo = summarizeTaskInfo;
        this.executor = Objects.requireNonNull(executor, "executor is null");
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo.get();
    }

    public synchronized void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        this.scheduleUpdate();
    }

    public synchronized void abort(TaskStatus taskStatus) {
        this.updateTaskInfo(this.taskInfo.get().withTaskStatus(taskStatus));
        this.stop();
    }

    public synchronized void taskStatusDone(TaskStatus taskStatus) {
        if (this.running && !TaskInfoFetcher.isDone(this.getTaskInfo())) {
            this.taskStatusDone.set(taskStatus);
        } else {
            this.getTaskInfo().withTaskStatus(taskStatus);
        }
    }

    private synchronized void stop() {
        this.running = false;
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    private synchronized void scheduleUpdate() {
        this.scheduledFuture = this.updateScheduledExecutor.scheduleWithFixedDelay(() -> {
            TaskInfoFetcher taskInfoFetcher = this;
            synchronized (taskInfoFetcher) {
                if (this.future != null && !this.future.isDone()) {
                    return;
                }
            }
            if (Duration.nanosSince((long)this.lastUpdateNanos.get()).toMillis() >= this.updateIntervalMillis) {
                this.sendNextRequest();
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private synchronized void sendNextRequest() {
        URI uri;
        ListenableFuture<?> errorRateLimit;
        TaskStatus taskStatus = this.getTaskInfo().getTaskStatus();
        if (!this.running) {
            return;
        }
        if (TaskInfoFetcher.isDone(this.getTaskInfo())) {
            this.stop();
            return;
        }
        if (this.future != null && !this.future.isDone()) {
            return;
        }
        if (this.taskStatusDone.get() != null) {
            this.lastRequest.set(true);
        }
        if (!(errorRateLimit = this.errorTracker.acquireRequestPermit()).isDone()) {
            errorRateLimit.addListener(this::sendNextRequest, this.executor);
            return;
        }
        HttpUriBuilder httpUriBuilder = HttpUriBuilder.uriBuilderFrom((URI)taskStatus.getSelf());
        URI uRI = uri = this.lastRequest.get() ? httpUriBuilder.build() : httpUriBuilder.addParameter("summarize", new String[0]).build();
        if (this.summarizeTaskInfo) {
            httpUriBuilder.addParameter("summarize", new String[0]);
        }
        Request request = Request.Builder.prepareGet().setUri(uri).setHeader("Content-Type", MediaType.JSON_UTF_8.toString()).build();
        this.errorTracker.startRequest();
        this.future = this.httpClient.executeAsync(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(this.taskInfoCodec));
        this.currentRequestStartNanos.set(System.nanoTime());
        Futures.addCallback(this.future, new SimpleHttpResponseHandler<TaskInfo>(this, request.getUri(), this.stats), (Executor)this.executor);
    }

    synchronized void updateTaskInfo(TaskInfo newValue) {
        this.taskInfo.setIf(newValue, oldValue -> {
            TaskStatus oldTaskStatus = oldValue.getTaskStatus();
            TaskStatus newTaskStatus = newValue.getTaskStatus();
            if (oldTaskStatus.getState().isDone()) {
                return false;
            }
            return newTaskStatus.getVersion() >= oldTaskStatus.getVersion();
        });
    }

    @Override
    public void success(TaskInfo newValue) {
        try (SetThreadName ignored = new SetThreadName("TaskInfoFetcher-%s", new Object[]{this.taskId});){
            this.lastUpdateNanos.set(System.nanoTime());
            this.updateStats(this.currentRequestStartNanos.get());
            this.errorTracker.requestSucceeded();
            this.updateTaskInfo(newValue);
            if (this.lastRequest.get() && !newValue.getTaskStatus().getState().isDone()) {
                log.error("%s taskStatus done but taskInfo is not", new Object[]{this.taskId});
                this.updateTaskInfo(this.taskInfo.get().withTaskStatus(this.taskStatusDone.get()));
            }
            if (this.lastRequest.get()) {
                this.stop();
            }
        }
    }

    @Override
    public void failed(Throwable cause) {
        try (SetThreadName ignored = new SetThreadName("TaskInfoFetcher-%s", new Object[]{this.taskId});){
            this.lastUpdateNanos.set(System.nanoTime());
            this.updateStats(this.currentRequestStartNanos.get());
            try {
                if (!TaskInfoFetcher.isDone(this.getTaskInfo())) {
                    this.errorTracker.requestFailed(cause);
                }
            }
            catch (Error e) {
                if (this.taskStatusDone.get() != null) {
                    this.updateTaskInfo(this.taskInfo.get().withTaskStatus(this.taskStatusDone.get()));
                    this.stop();
                }
                this.onFail.accept(e);
                throw e;
            }
            catch (RuntimeException e) {
                this.onFail.accept(e);
            }
        }
    }

    @Override
    public void fatal(Throwable cause) {
        try (SetThreadName ignored = new SetThreadName("TaskInfoFetcher-%s", new Object[]{this.taskId});){
            if (this.taskStatusDone.get() != null) {
                this.updateTaskInfo(this.taskInfo.get().withTaskStatus(this.taskStatusDone.get()));
                this.stop();
            }
            this.updateStats(this.currentRequestStartNanos.get());
            this.onFail.accept(cause);
        }
    }

    private void updateStats(long currentRequestStartNanos) {
        this.stats.infoRoundTripMillis(Duration.nanosSince((long)currentRequestStartNanos).toMillis());
    }

    private static boolean isDone(TaskInfo taskInfo) {
        return taskInfo.getTaskStatus().getState().isDone();
    }
}

