/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.GroupByHashPageIndexerFactory;
import com.facebook.presto.PagesIndexPageSorter;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.block.BlockJsonSerde;
import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.client.ServerInfo;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.connector.system.SystemConnectorModule;
import com.facebook.presto.event.query.QueryCompletionEvent;
import com.facebook.presto.event.query.QueryCreatedEvent;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.event.query.QueryMonitorConfig;
import com.facebook.presto.event.query.SplitCompletionEvent;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.NodeTaskMap;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryPerformanceFetcher;
import com.facebook.presto.execution.QueryPerformanceFetcherProvider;
import com.facebook.presto.execution.SqlTaskManager;
import com.facebook.presto.execution.TaskExecutor;
import com.facebook.presto.execution.TaskInfo;
import com.facebook.presto.execution.TaskManager;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskStatus;
import com.facebook.presto.execution.scheduler.FlatNetworkTopology;
import com.facebook.presto.execution.scheduler.LegacyNetworkTopology;
import com.facebook.presto.execution.scheduler.NetworkTopology;
import com.facebook.presto.execution.scheduler.NodeScheduler;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.execution.scheduler.NodeSchedulerExporter;
import com.facebook.presto.failureDetector.FailureDetector;
import com.facebook.presto.failureDetector.FailureDetectorModule;
import com.facebook.presto.index.IndexManager;
import com.facebook.presto.memory.LocalMemoryManager;
import com.facebook.presto.memory.LocalMemoryManagerExporter;
import com.facebook.presto.memory.MemoryInfo;
import com.facebook.presto.memory.MemoryManagerConfig;
import com.facebook.presto.memory.MemoryPoolAssignmentsRequest;
import com.facebook.presto.memory.MemoryResource;
import com.facebook.presto.memory.NodeMemoryConfig;
import com.facebook.presto.memory.ReservedSystemMemoryConfig;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.CatalogManagerConfig;
import com.facebook.presto.metadata.DiscoveryNodeManager;
import com.facebook.presto.metadata.ForNodeManager;
import com.facebook.presto.metadata.HandleJsonModule;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.metadata.TablePropertyManager;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.operator.ExchangeClientConfig;
import com.facebook.presto.operator.ExchangeClientFactory;
import com.facebook.presto.operator.ExchangeClientSupplier;
import com.facebook.presto.operator.ForExchange;
import com.facebook.presto.operator.index.IndexJoinLookupStats;
import com.facebook.presto.server.AsyncHttpExecutionMBean;
import com.facebook.presto.server.CodeCacheGcConfig;
import com.facebook.presto.server.CodeCacheGcTrigger;
import com.facebook.presto.server.ConditionalModule;
import com.facebook.presto.server.CoordinatorModule;
import com.facebook.presto.server.ExchangeExecutionMBean;
import com.facebook.presto.server.ForAsyncHttp;
import com.facebook.presto.server.NodeResource;
import com.facebook.presto.server.PagesResponseWriter;
import com.facebook.presto.server.PluginManager;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.server.ServerConfig;
import com.facebook.presto.server.ServerInfoResource;
import com.facebook.presto.server.SliceDeserializer;
import com.facebook.presto.server.SliceSerializer;
import com.facebook.presto.server.TaskResource;
import com.facebook.presto.server.TaskUpdateRequest;
import com.facebook.presto.server.ThreadResource;
import com.facebook.presto.server.ThrowableMapper;
import com.facebook.presto.server.remotetask.HttpLocationFactory;
import com.facebook.presto.spi.ConnectorPageSinkProvider;
import com.facebook.presto.spi.ConnectorPageSourceProvider;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.PageIndexerFactory;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.split.PageSinkProvider;
import com.facebook.presto.split.PageSourceManager;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.split.SplitManager;
import com.facebook.presto.sql.Serialization;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.planner.CompilerConfig;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.PlanOptimizersFactory;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.transaction.ForTransactionManager;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.transaction.TransactionManagerConfig;
import com.facebook.presto.type.TypeDeserializer;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.FinalizerService;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.Reflection;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.Multibinder;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.discovery.client.DiscoveryBinder;
import io.airlift.discovery.client.ServiceDescriptor;
import io.airlift.event.client.EventBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.jaxrs.JaxrsBinder;
import io.airlift.json.JsonBinder;
import io.airlift.json.JsonCodecBinder;
import io.airlift.node.NodeInfo;
import io.airlift.slice.Slice;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;
import org.weakref.jmx.guice.ExportBinder;

public class ServerMainModule
extends AbstractConfigurationAwareModule {
    private final SqlParserOptions sqlParserOptions;

    public ServerMainModule(SqlParserOptions sqlParserOptions) {
        this.sqlParserOptions = Objects.requireNonNull(sqlParserOptions, "sqlParserOptions is null");
    }

    protected void setup(Binder binder) {
        ServerConfig serverConfig = (ServerConfig)this.buildConfigObject(ServerConfig.class);
        if (serverConfig.isCoordinator()) {
            this.install((ConfigurationAwareModule)new CoordinatorModule());
            binder.bind((TypeLiteral)new TypeLiteral<Optional<QueryPerformanceFetcher>>(){}).toProvider(QueryPerformanceFetcherProvider.class).in(Scopes.SINGLETON);
        } else {
            binder.bind((TypeLiteral)new TypeLiteral<Optional<QueryPerformanceFetcher>>(){}).toInstance(Optional.empty());
            binder.bind(QueryManager.class).toInstance(Reflection.newProxy(QueryManager.class, (proxy, method, args) -> {
                throw new UnsupportedOperationException();
            }));
        }
        ConfigBinder.configBinder((Binder)binder).bindConfig(FeaturesConfig.class);
        binder.bind(SqlParser.class).in(Scopes.SINGLETON);
        binder.bind(SqlParserOptions.class).toInstance((Object)this.sqlParserOptions);
        ServerMainModule.bindFailureDetector(binder, serverConfig.isCoordinator());
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ThrowableMapper.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryManagerConfig.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ViewDefinition.class);
        binder.bind(SessionPropertyManager.class).in(Scopes.SINGLETON);
        binder.bind(SystemSessionProperties.class).in(Scopes.SINGLETON);
        binder.bind(TablePropertyManager.class).in(Scopes.SINGLETON);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindSelector("presto");
        binder.bind(InternalNodeManager.class).to(DiscoveryNodeManager.class).in(Scopes.SINGLETON);
        binder.bind(NodeManager.class).to(Key.get(InternalNodeManager.class)).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("node-manager", ForNodeManager.class).withTracing().withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
        });
        ConfigBinder.configBinder((Binder)binder).bindConfig(NodeSchedulerConfig.class);
        binder.bind(NodeScheduler.class).in(Scopes.SINGLETON);
        binder.bind(NodeSchedulerExporter.class).in(Scopes.SINGLETON);
        binder.bind(NodeTaskMap.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(NodeScheduler.class).withGeneratedName();
        this.install(ConditionalModule.conditionalModule(NodeSchedulerConfig.class, config -> "legacy".equalsIgnoreCase(config.getNetworkTopology()), moduleBinder -> moduleBinder.bind(NetworkTopology.class).to(LegacyNetworkTopology.class).in(Scopes.SINGLETON)));
        this.install(ConditionalModule.conditionalModule(NodeSchedulerConfig.class, config -> "flat".equalsIgnoreCase(config.getNetworkTopology()), moduleBinder -> moduleBinder.bind(NetworkTopology.class).to(FlatNetworkTopology.class).in(Scopes.SINGLETON)));
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(TaskResource.class);
        ExportBinder.newExporter((Binder)binder).export(TaskResource.class).withGeneratedName();
        binder.bind(TaskManager.class).to(SqlTaskManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CodeCacheGcConfig.class);
        binder.bind(CodeCacheGcTrigger.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(MemoryManagerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(NodeMemoryConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ReservedSystemMemoryConfig.class);
        binder.bind(LocalMemoryManager.class).in(Scopes.SINGLETON);
        binder.bind(LocalMemoryManagerExporter.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TaskManager.class).withGeneratedName();
        binder.bind(TaskExecutor.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(TaskExecutor.class).withGeneratedName();
        binder.bind(LocalExecutionPlanner.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CompilerConfig.class);
        binder.bind(ExpressionCompiler.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ExpressionCompiler.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(TaskManagerConfig.class);
        binder.bind(IndexJoinLookupStats.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(IndexJoinLookupStats.class).withGeneratedName();
        binder.bind(AsyncHttpExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(AsyncHttpExecutionMBean.class).withGeneratedName();
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskStatus.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskInfo.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(PagesResponseWriter.class);
        binder.bind((TypeLiteral)new TypeLiteral<ExchangeClientSupplier>(){}).to(ExchangeClientFactory.class).in(Scopes.SINGLETON);
        HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("exchange", ForExchange.class).withTracing().withConfigDefaults(config -> {
            config.setIdleTimeout(new Duration(30.0, TimeUnit.SECONDS));
            config.setRequestTimeout(new Duration(10.0, TimeUnit.SECONDS));
            config.setMaxConnectionsPerServer(250);
        });
        ConfigBinder.configBinder((Binder)binder).bindConfig(ExchangeClientConfig.class);
        binder.bind(ExchangeExecutionMBean.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ExchangeExecutionMBean.class).withGeneratedName();
        binder.bind(LocationFactory.class).to(HttpLocationFactory.class).in(Scopes.SINGLETON);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(MemoryResource.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(MemoryInfo.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(MemoryPoolAssignmentsRequest.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(TransactionManagerConfig.class);
        binder.bind(PageSourceManager.class).in(Scopes.SINGLETON);
        binder.bind(PageSourceProvider.class).to(PageSourceManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ConnectorPageSourceProvider.class);
        binder.bind(PageSinkManager.class).in(Scopes.SINGLETON);
        binder.bind(PageSinkProvider.class).to(PageSinkManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, ConnectorPageSinkProvider.class);
        binder.bind(CatalogManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogManagerConfig.class);
        binder.bind(MetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(Metadata.class).to(MetadataManager.class).in(Scopes.SINGLETON);
        binder.bind(TypeRegistry.class).in(Scopes.SINGLETON);
        binder.bind(TypeManager.class).to(TypeRegistry.class).in(Scopes.SINGLETON);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Type.class).to(TypeDeserializer.class);
        Multibinder.newSetBinder((Binder)binder, Type.class);
        binder.bind(SplitManager.class).in(Scopes.SINGLETON);
        binder.bind(NodePartitioningManager.class).in(Scopes.SINGLETON);
        binder.bind(IndexManager.class).in(Scopes.SINGLETON);
        binder.install((Module)new HandleJsonModule());
        binder.bind(ConnectorManager.class).in(Scopes.SINGLETON);
        binder.install((Module)new SystemConnectorModule());
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(TaskUpdateRequest.class);
        JsonCodecBinder.jsonCodecBinder((Binder)binder).bindJsonCodec(ConnectorSplit.class);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Slice.class).to(SliceSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Slice.class).to(SliceDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Expression.class).to(Serialization.ExpressionSerializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Expression.class).to(Serialization.ExpressionDeserializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(FunctionCall.class).to(Serialization.FunctionCallDeserializer.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(QueryMonitorConfig.class);
        binder.bind(QueryMonitor.class).in(Scopes.SINGLETON);
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{QueryCreatedEvent.class});
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{QueryCompletionEvent.class});
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{SplitCompletionEvent.class});
        String prestoVersion = serverConfig.getPrestoVersion();
        if (prestoVersion == null) {
            prestoVersion = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();
        }
        Preconditions.checkState((prestoVersion != null ? 1 : 0) != 0, (Object)"presto.version must be provided when it cannot be automatically determined");
        NodeVersion nodeVersion = new NodeVersion(prestoVersion);
        binder.bind(NodeVersion.class).toInstance((Object)nodeVersion);
        DiscoveryBinder.discoveryBinder((Binder)binder).bindHttpAnnouncement("presto").addProperty("node_version", nodeVersion.toString()).addProperty("coordinator", String.valueOf(serverConfig.isCoordinator())).addProperty("datasources", Strings.nullToEmpty((String)serverConfig.getDataSources()));
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ServerInfoResource.class);
        binder.bind(PluginManager.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(PluginManagerConfig.class);
        binder.bind((TypeLiteral)new TypeLiteral<List<PlanOptimizer>>(){}).toProvider(PlanOptimizersFactory.class).in(Scopes.SINGLETON);
        binder.bind(BlockEncodingManager.class).in(Scopes.SINGLETON);
        binder.bind(BlockEncodingSerde.class).to(BlockEncodingManager.class).in(Scopes.SINGLETON);
        Multibinder.newSetBinder((Binder)binder, (TypeLiteral)new TypeLiteral<BlockEncodingFactory<?>>(){});
        JsonBinder.jsonBinder((Binder)binder).addSerializerBinding(Block.class).to(BlockJsonSerde.Serializer.class);
        JsonBinder.jsonBinder((Binder)binder).addDeserializerBinding(Block.class).to(BlockJsonSerde.Deserializer.class);
        JaxrsBinder.jaxrsBinder((Binder)binder).bind(ThreadResource.class);
        binder.bind(PageSorter.class).to(PagesIndexPageSorter.class).in(Scopes.SINGLETON);
        binder.bind(PageIndexerFactory.class).to(GroupByHashPageIndexerFactory.class).in(Scopes.SINGLETON);
        binder.bind(FinalizerService.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public ServerInfo createServerInfo(NodeVersion nodeVersion, NodeInfo nodeInfo) {
        return new ServerInfo(nodeVersion, nodeInfo.getEnvironment());
    }

    @Provides
    @Singleton
    @ForExchange
    public ScheduledExecutorService createExchangeExecutor(ExchangeClientConfig config) {
        return Executors.newScheduledThreadPool(config.getClientThreads(), Threads.daemonThreadsNamed((String)"exchange-client-%s"));
    }

    @Provides
    @Singleton
    @ForAsyncHttp
    public static ExecutorService createAsyncHttpResponseCoreExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"async-http-response-%s"));
    }

    @Provides
    @Singleton
    @ForAsyncHttp
    public static BoundedExecutor createAsyncHttpResponseExecutor(@ForAsyncHttp ExecutorService coreExecutor, TaskManagerConfig config) {
        return new BoundedExecutor((Executor)coreExecutor, config.getHttpResponseThreads());
    }

    @Provides
    @Singleton
    @ForAsyncHttp
    public static ScheduledExecutorService createAsyncHttpTimeoutExecutor(TaskManagerConfig config) {
        return Executors.newScheduledThreadPool(config.getHttpTimeoutThreads(), Threads.daemonThreadsNamed((String)"async-http-timeout-%s"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ScheduledExecutorService createTransactionIdleCheckExecutor() {
        return Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"transaction-idle-check"));
    }

    @Provides
    @Singleton
    @ForTransactionManager
    public static ExecutorService createTransactionFinishingExecutor() {
        return Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"transaction-finishing-%s"));
    }

    @Provides
    @Singleton
    public static TransactionManager createTransactionManager(TransactionManagerConfig config, @ForTransactionManager ScheduledExecutorService idleCheckExecutor, @ForTransactionManager ExecutorService finishingExecutor) {
        return TransactionManager.create(config, idleCheckExecutor, finishingExecutor);
    }

    private static void bindFailureDetector(Binder binder, boolean coordinator) {
        if (coordinator) {
            binder.install((Module)new FailureDetectorModule());
            JaxrsBinder.jaxrsBinder((Binder)binder).bind(NodeResource.class);
        } else {
            binder.bind(FailureDetector.class).toInstance((Object)new FailureDetector(){

                @Override
                public Set<ServiceDescriptor> getFailed() {
                    return ImmutableSet.of();
                }
            });
        }
    }
}

