/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.metadata.FunctionFactory;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.server.PluginClassLoader;
import com.facebook.presto.server.PluginDiscovery;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.ParametricType;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Ordering;
import com.google.inject.Injector;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.http.server.HttpServerInfo;
import io.airlift.log.Logger;
import io.airlift.node.NodeInfo;
import io.airlift.resolver.ArtifactResolver;
import io.airlift.resolver.DefaultArtifact;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.sonatype.aether.artifact.Artifact;

@ThreadSafe
public class PluginManager {
    private static final List<String> HIDDEN_CLASSES = ImmutableList.builder().add((Object)"org.slf4j").build();
    private static final ImmutableList<String> PARENT_FIRST_CLASSES = ImmutableList.builder().add((Object)"com.facebook.presto").add((Object)"com.fasterxml.jackson").add((Object)"io.airlift.slice").add((Object)"javax.inject").add((Object)"javax.annotation").add((Object)"java.").build();
    private static final Logger log = Logger.get(PluginManager.class);
    private final Injector injector;
    private final ConnectorManager connectorManager;
    private final Metadata metadata;
    private final AccessControlManager accessControlManager;
    private final BlockEncodingManager blockEncodingManager;
    private final TypeRegistry typeRegistry;
    private final ArtifactResolver resolver;
    private final File installedPluginsDir;
    private final List<String> plugins;
    private final Map<String, String> optionalConfig;
    private final AtomicBoolean pluginsLoading = new AtomicBoolean();
    private final AtomicBoolean pluginsLoaded = new AtomicBoolean();

    @Inject
    public PluginManager(Injector injector, NodeInfo nodeInfo, HttpServerInfo httpServerInfo, PluginManagerConfig config, ConnectorManager connectorManager, ConfigurationFactory configurationFactory, Metadata metadata, AccessControlManager accessControlManager, BlockEncodingManager blockEncodingManager, TypeRegistry typeRegistry) {
        Objects.requireNonNull(injector, "injector is null");
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(httpServerInfo, "httpServerInfo is null");
        Objects.requireNonNull(config, "config is null");
        Objects.requireNonNull(configurationFactory, "configurationFactory is null");
        this.injector = injector;
        this.installedPluginsDir = config.getInstalledPluginsDir();
        this.plugins = config.getPlugins() == null ? ImmutableList.of() : ImmutableList.copyOf(config.getPlugins());
        this.resolver = new ArtifactResolver(config.getMavenLocalRepository(), config.getMavenRemoteRepository());
        TreeMap<String, String> optionalConfig = new TreeMap<String, String>(configurationFactory.getProperties());
        optionalConfig.put("node.id", nodeInfo.getNodeId());
        optionalConfig.put("http-server.http.port", Integer.toString(httpServerInfo.getHttpUri().getPort()));
        this.optionalConfig = ImmutableMap.copyOf(optionalConfig);
        this.connectorManager = Objects.requireNonNull(connectorManager, "connectorManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControlManager = Objects.requireNonNull(accessControlManager, "accessControlManager is null");
        this.blockEncodingManager = Objects.requireNonNull(blockEncodingManager, "blockEncodingManager is null");
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry is null");
    }

    public boolean arePluginsLoaded() {
        return this.pluginsLoaded.get();
    }

    public void loadPlugins() throws Exception {
        if (!this.pluginsLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : PluginManager.listFiles(this.installedPluginsDir)) {
            if (!file.isDirectory()) continue;
            this.loadPlugin(file.getAbsolutePath());
        }
        for (String plugin : this.plugins) {
            this.loadPlugin(plugin);
        }
        this.metadata.verifyComparableOrderableContract();
        this.pluginsLoaded.set(true);
    }

    private void loadPlugin(String plugin) throws Exception {
        log.info("-- Loading plugin %s --", new Object[]{plugin});
        URLClassLoader pluginClassLoader = this.buildClassLoader(plugin);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader((ClassLoader)pluginClassLoader);){
            this.loadPlugin(pluginClassLoader);
        }
        log.info("-- Finished loading plugin %s --", new Object[]{plugin});
    }

    private void loadPlugin(URLClassLoader pluginClassLoader) throws Exception {
        ServiceLoader<Plugin> serviceLoader = ServiceLoader.load(Plugin.class, pluginClassLoader);
        ImmutableList plugins = ImmutableList.copyOf(serviceLoader);
        if (plugins.isEmpty()) {
            log.warn("No service providers of type %s", new Object[]{Plugin.class.getName()});
        }
        for (Plugin plugin : plugins) {
            log.info("Installing %s", new Object[]{plugin.getClass().getName()});
            this.installPlugin(plugin);
        }
    }

    public void installPlugin(Plugin plugin) {
        this.injector.injectMembers((Object)plugin);
        plugin.setOptionalConfig(this.optionalConfig);
        for (BlockEncodingFactory blockEncodingFactory : plugin.getServices(BlockEncodingFactory.class)) {
            log.info("Registering block encoding %s", new Object[]{blockEncodingFactory.getName()});
            this.blockEncodingManager.addBlockEncodingFactory(blockEncodingFactory);
        }
        for (Type type : plugin.getServices(Type.class)) {
            log.info("Registering type %s", new Object[]{type.getTypeSignature()});
            this.typeRegistry.addType(type);
        }
        for (ParametricType parametricType : plugin.getServices(ParametricType.class)) {
            log.info("Registering parametric type %s", new Object[]{parametricType.getName()});
            this.typeRegistry.addParametricType(parametricType);
        }
        for (com.facebook.presto.spi.ConnectorFactory connectorFactory : plugin.getServices(com.facebook.presto.spi.ConnectorFactory.class)) {
            log.info("Registering legacy connector %s", new Object[]{connectorFactory.getName()});
            this.connectorManager.addConnectorFactory(connectorFactory);
        }
        for (com.facebook.presto.spi.ConnectorFactory connectorFactory : plugin.getServices(ConnectorFactory.class)) {
            log.info("Registering connector %s", new Object[]{connectorFactory.getName()});
            this.connectorManager.addConnectorFactory((ConnectorFactory)connectorFactory);
        }
        for (FunctionFactory functionFactory : plugin.getServices(FunctionFactory.class)) {
            log.info("Registering functions from %s", new Object[]{functionFactory.getClass().getName()});
            this.metadata.addFunctions(functionFactory.listFunctions());
        }
        for (SystemAccessControlFactory accessControlFactory : plugin.getServices(SystemAccessControlFactory.class)) {
            log.info("Registering system access control %s", new Object[]{accessControlFactory.getName()});
            this.accessControlManager.addSystemAccessControlFactory(accessControlFactory);
        }
    }

    private URLClassLoader buildClassLoader(String plugin) throws Exception {
        File file = new File(plugin);
        if (file.isFile() && (file.getName().equals("pom.xml") || file.getName().endsWith(".pom"))) {
            return this.buildClassLoaderFromPom(file);
        }
        if (file.isDirectory()) {
            return this.buildClassLoaderFromDirectory(file);
        }
        return this.buildClassLoaderFromCoordinates(plugin);
    }

    private URLClassLoader buildClassLoaderFromPom(File pomFile) throws Exception {
        List artifacts = this.resolver.resolvePom(pomFile);
        URLClassLoader classLoader = this.createClassLoader(artifacts, pomFile.getPath());
        Artifact artifact = (Artifact)artifacts.get(0);
        Set<String> plugins = PluginDiscovery.discoverPlugins(artifact, classLoader);
        if (!plugins.isEmpty()) {
            PluginDiscovery.writePluginServices(plugins, artifact.getFile());
        }
        return classLoader;
    }

    private URLClassLoader buildClassLoaderFromDirectory(File dir) throws Exception {
        log.debug("Classpath for %s:", new Object[]{dir.getName()});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : PluginManager.listFiles(dir)) {
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader buildClassLoaderFromCoordinates(String coordinates) throws Exception {
        DefaultArtifact rootArtifact = new DefaultArtifact(coordinates);
        List artifacts = this.resolver.resolveArtifacts(new Artifact[]{rootArtifact});
        return this.createClassLoader(artifacts, rootArtifact.toString());
    }

    private URLClassLoader createClassLoader(List<Artifact> artifacts, String name) throws IOException {
        log.debug("Classpath for %s:", new Object[]{name});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : PluginManager.sortedArtifacts(artifacts)) {
            if (artifact.getFile() == null) {
                throw new RuntimeException("Could not resolve artifact: " + artifact);
            }
            File file = artifact.getFile().getCanonicalFile();
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return this.createClassLoader(urls);
    }

    private URLClassLoader createClassLoader(List<URL> urls) {
        ClassLoader parent = this.getClass().getClassLoader();
        return new PluginClassLoader(urls, parent, (Iterable<String>)HIDDEN_CLASSES, (Iterable<String>)PARENT_FIRST_CLASSES);
    }

    private static List<File> listFiles(File installedPluginsDir) {
        Object[] files;
        if (installedPluginsDir != null && installedPluginsDir.isDirectory() && (files = installedPluginsDir.listFiles()) != null) {
            Arrays.sort(files);
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    private static List<Artifact> sortedArtifacts(List<Artifact> artifacts) {
        ArrayList<Artifact> list = new ArrayList<Artifact>(artifacts);
        Collections.sort(list, Ordering.natural().nullsLast().onResultOf(Artifact::getFile));
        return list;
    }
}

