/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigurationAwareModule;
import java.util.function.Predicate;

public class ConditionalModule<T>
extends AbstractConfigurationAwareModule {
    private final Class<T> config;
    private final Predicate<T> predicate;
    private final Module module;

    public static <T> ConfigurationAwareModule conditionalModule(Class<T> config, Predicate<T> predicate, Module module) {
        return new ConditionalModule<T>(config, predicate, module);
    }

    private ConditionalModule(Class<T> config, Predicate<T> predicate, Module module) {
        this.config = config;
        this.predicate = predicate;
        this.module = module;
    }

    protected void setup(Binder binder) {
        Object configuration = this.buildConfigObject(this.config);
        if (this.predicate.test(configuration)) {
            if (this.module instanceof ConfigurationAwareModule) {
                this.install((ConfigurationAwareModule)this.module);
            } else {
                binder.install(this.module);
            }
        }
    }
}

