/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.SessionRepresentation;
import com.facebook.presto.execution.QueryId;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.joda.time.DateTime;

@Immutable
public class BasicQueryInfo {
    private final QueryId queryId;
    private final SessionRepresentation session;
    private final QueryState state;
    private final ErrorType errorType;
    private final ErrorCode errorCode;
    private final boolean scheduled;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final URI self;
    private final String query;
    private final Duration elapsedTime;
    private final Duration executionTime;
    private final Duration cpuTime;
    private final DateTime endTime;
    private final DateTime createTime;
    private final DataSize currentMemory;
    private final DataSize peakMemory;
    private final double cumulativeMemory;
    private final int runningDrivers;
    private final int queuedDrivers;
    private final int completedDrivers;
    private final int totalDrivers;

    public BasicQueryInfo(QueryId queryId, SessionRepresentation session, QueryState state, ErrorType errorType, ErrorCode errorCode, boolean scheduled, boolean fullyBlocked, Set<BlockedReason> blockedReasons, URI self, String query, Duration elapsedTime, Duration executionTime, Duration cpuTime, DateTime endTime, DateTime createTime, DataSize currentMemory, DataSize peakMemory, double cumulativeMemory, int runningDrivers, int queuedDrivers, int completedDrivers, int totalDrivers) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.errorType = errorType;
        this.errorCode = errorCode;
        this.scheduled = scheduled;
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.self = Objects.requireNonNull(self, "self is null");
        this.query = Objects.requireNonNull(query, "query is null");
        this.elapsedTime = elapsedTime;
        this.executionTime = executionTime;
        this.cpuTime = cpuTime;
        this.endTime = endTime;
        this.createTime = createTime;
        this.currentMemory = currentMemory;
        this.peakMemory = peakMemory;
        this.cumulativeMemory = cumulativeMemory;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is less than zero");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is less than zero");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is less than zero");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is less than zero");
        this.totalDrivers = totalDrivers;
    }

    public BasicQueryInfo(QueryInfo queryInfo) {
        this(queryInfo.getQueryId(), queryInfo.getSession(), queryInfo.getState(), queryInfo.getErrorType(), queryInfo.getErrorCode(), queryInfo.isScheduled(), queryInfo.getQueryStats().isFullyBlocked(), queryInfo.getQueryStats().getBlockedReasons(), queryInfo.getSelf(), queryInfo.getQuery(), queryInfo.getQueryStats().getElapsedTime(), queryInfo.getQueryStats().getExecutionTime(), queryInfo.getQueryStats().getTotalCpuTime(), queryInfo.getQueryStats().getEndTime(), queryInfo.getQueryStats().getCreateTime(), queryInfo.getQueryStats().getTotalMemoryReservation(), queryInfo.getQueryStats().getPeakMemoryReservation(), queryInfo.getQueryStats().getCumulativeMemory(), queryInfo.getQueryStats().getRunningDrivers(), queryInfo.getQueryStats().getQueuedDrivers(), queryInfo.getQueryStats().getCompletedDrivers(), queryInfo.getQueryStats().getTotalDrivers());
    }

    @JsonProperty
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    public SessionRepresentation getSession() {
        return this.session;
    }

    @JsonProperty
    public QueryState getState() {
        return this.state;
    }

    @Nullable
    @JsonProperty
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public URI getSelf() {
        return this.self;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public long getExecutionTimeMillis() {
        return this.executionTime.toMillis();
    }

    @JsonProperty
    public long getCpuTimeMillis() {
        return this.cpuTime.toMillis();
    }

    @JsonProperty
    public long getElapsedTimeMillis() {
        return this.elapsedTime.toMillis();
    }

    @JsonProperty
    public DateTime getEndTime() {
        return this.endTime;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return this.createTime;
    }

    @JsonProperty
    public double getCumulativeMemory() {
        return this.cumulativeMemory;
    }

    @JsonProperty
    public long getCurrentMemoryBytes() {
        return this.currentMemory.toBytes();
    }

    @JsonProperty
    public long getPeakMemoryBytes() {
        return this.peakMemory.toBytes();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("queryId", (Object)this.queryId).add("state", (Object)this.state).toString();
    }
}

