/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.annotations;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SignatureBinder;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.annotations.OperatorDependency;
import com.facebook.presto.operator.scalar.annotations.TypeParameter;
import com.facebook.presto.operator.scalar.annotations.TypeParameterSpecialization;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.Constraint;
import com.facebook.presto.type.LiteralParameters;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ScalarImplementation {
    private final Signature signature;
    private final boolean nullable;
    private final List<Boolean> nullableArguments;
    private final MethodHandle methodHandle;
    private final List<ImplementationDependency> dependencies;
    private final Optional<MethodHandle> constructor;
    private final List<ImplementationDependency> constructorDependencies;
    private final List<Class<?>> argumentNativeContainerTypes;
    private final Map<String, Class<?>> specializedTypeParameters;

    public ScalarImplementation(Signature signature, boolean nullable, List<Boolean> nullableArguments, MethodHandle methodHandle, List<ImplementationDependency> dependencies, Optional<MethodHandle> constructor, List<ImplementationDependency> constructorDependencies, List<Class<?>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.nullable = nullable;
        this.nullableArguments = ImmutableList.copyOf((Collection)Objects.requireNonNull(nullableArguments, "nullableArguments is null"));
        this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
        this.dependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(dependencies, "dependencies is null"));
        this.constructor = Objects.requireNonNull(constructor, "constructor is null");
        this.constructorDependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(constructorDependencies, "constructorDependencies is null"));
        this.argumentNativeContainerTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes is null"));
        this.specializedTypeParameters = ImmutableMap.copyOf(Objects.requireNonNull(specializedTypeParameters, "specializedTypeParameters is null"));
    }

    public Optional<MethodHandleAndConstructor> specialize(Signature boundSignature, BoundVariables boundVariables, TypeManager typeManager, FunctionRegistry functionRegistry) {
        for (Map.Entry<String, Class<?>> entry : this.specializedTypeParameters.entrySet()) {
            if (entry.getValue().isAssignableFrom(boundVariables.getTypeVariable(entry.getKey()).getJavaType())) continue;
            return Optional.empty();
        }
        Class<?> returnContainerType = ScalarImplementation.getNullAwareContainerType(typeManager.getType(boundSignature.getReturnType()).getJavaType(), this.nullable);
        if (!returnContainerType.equals(this.methodHandle.type().returnType())) {
            return Optional.empty();
        }
        for (int i = 0; i < boundSignature.getArgumentTypes().size(); ++i) {
            Class<?> argumentContainerType = ScalarImplementation.getNullAwareContainerType(typeManager.getType(boundSignature.getArgumentTypes().get(i)).getJavaType(), this.nullableArguments.get(i));
            if (this.argumentNativeContainerTypes.get(i).isAssignableFrom(argumentContainerType)) continue;
            return Optional.empty();
        }
        MethodHandle methodHandle = this.methodHandle;
        for (ImplementationDependency dependency : this.dependencies) {
            methodHandle = methodHandle.bindTo(dependency.resolve(boundVariables.getTypeVariables(), typeManager, functionRegistry));
        }
        MethodHandle constructor = null;
        if (this.constructor.isPresent()) {
            constructor = this.constructor.get();
            for (ImplementationDependency dependency : this.constructorDependencies) {
                constructor = constructor.bindTo(dependency.resolve(boundVariables.getTypeVariables(), typeManager, functionRegistry));
            }
        }
        return Optional.of(new MethodHandleAndConstructor(methodHandle, Optional.ofNullable(constructor)));
    }

    private static Class<?> getNullAwareContainerType(Class<?> clazz, boolean nullable) {
        if (nullable) {
            return Primitives.wrap(clazz);
        }
        return clazz;
    }

    public boolean hasSpecializedTypeParameters() {
        return !this.specializedTypeParameters.isEmpty();
    }

    public Signature getSignature() {
        return this.signature;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public List<Boolean> getNullableArguments() {
        return this.nullableArguments;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public List<ImplementationDependency> getDependencies() {
        return this.dependencies;
    }

    public static final class Parser {
        private static final Set<OperatorType> COMPARABLE_TYPE_OPERATORS = ImmutableSet.of((Object)((Object)OperatorType.EQUAL), (Object)((Object)OperatorType.NOT_EQUAL), (Object)((Object)OperatorType.HASH_CODE));
        private static final Set<OperatorType> ORDERABLE_TYPE_OPERATORS = ImmutableSet.of((Object)((Object)OperatorType.LESS_THAN), (Object)((Object)OperatorType.LESS_THAN_OR_EQUAL), (Object)((Object)OperatorType.GREATER_THAN), (Object)((Object)OperatorType.GREATER_THAN_OR_EQUAL), (Object)((Object)OperatorType.BETWEEN));
        private final String functionName;
        private final boolean nullable;
        private final List<Boolean> nullableArguments = new ArrayList<Boolean>();
        private final TypeSignature returnType;
        private final List<TypeSignature> argumentTypes = new ArrayList<TypeSignature>();
        private final List<Class<?>> argumentNativeContainerTypes = new ArrayList();
        private final MethodHandle methodHandle;
        private final List<ImplementationDependency> dependencies = new ArrayList<ImplementationDependency>();
        private final LinkedHashSet<TypeParameter> typeParameters = new LinkedHashSet();
        private final Set<String> literalParameters = new HashSet<String>();
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Optional<MethodHandle> constructorMethodHandle;
        private final List<ImplementationDependency> constructorDependencies = new ArrayList<ImplementationDependency>();
        private final List<LongVariableConstraint> longVariableConstraints = new ArrayList<LongVariableConstraint>();

        private Parser(String functionName, Method method, Map<Set<TypeParameter>, Constructor<?>> constructors) {
            this.functionName = Objects.requireNonNull(functionName, "functionName is null");
            this.nullable = method.getAnnotation(Nullable.class) != null;
            Stream.of(method.getAnnotationsByType(TypeParameter.class)).forEach(this.typeParameters::add);
            LiteralParameters literalParametersAnnotation = method.getAnnotation(LiteralParameters.class);
            if (literalParametersAnnotation != null) {
                this.literalParameters.addAll(Arrays.asList(literalParametersAnnotation.value()));
            }
            SqlType returnType = method.getAnnotation(SqlType.class);
            Objects.requireNonNull(returnType, String.format("%s is missing @SqlType annotation", method));
            this.returnType = TypeSignature.parseTypeSignature((String)returnType.value(), this.literalParameters);
            Class<?> actualReturnType = method.getReturnType();
            if (Primitives.isWrapperType(actualReturnType)) {
                Preconditions.checkArgument((boolean)this.nullable, (String)"Method %s has return value with type %s that is missing @Nullable", (Object[])new Object[]{method, actualReturnType});
            }
            Stream.of(method.getAnnotationsByType(Constraint.class)).forEach(annotation -> this.longVariableConstraints.add(new LongVariableConstraint(annotation.variable(), annotation.expression())));
            this.specializedTypeParameters = this.getDeclaredSpecializedTypeParameters(method);
            this.parseArguments(method);
            this.constructorMethodHandle = this.getConstructor(method, constructors);
            this.methodHandle = this.getMethodHandle(method);
        }

        private void parseArguments(Method method) {
            ImmutableSet typeParameterNames = this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableCollectors.toImmutableSet());
            for (int i = 0; i < method.getParameterCount(); ++i) {
                Annotation[] annotations = method.getParameterAnnotations()[i];
                Class<?> parameterType = method.getParameterTypes()[i];
                if (parameterType == ConnectorSession.class) continue;
                if (Parser.containsMetaParameter(annotations)) {
                    Preconditions.checkArgument((annotations.length == 1 ? 1 : 0) != 0, (Object)"Meta parameters may only have a single annotation");
                    Preconditions.checkArgument((boolean)this.argumentTypes.isEmpty(), (Object)"Meta parameter must come before parameters");
                    Annotation annotation = annotations[0];
                    if (annotation instanceof TypeParameter) {
                        Preconditions.checkArgument((boolean)this.typeParameters.contains(annotation), (Object)"Injected type parameters must be declared with @TypeParameter annotation on the method");
                    }
                    this.dependencies.add(Parser.parseDependency(annotation));
                    continue;
                }
                SqlType type = null;
                boolean nullableArgument = false;
                for (Annotation annotation : annotations) {
                    if (annotation instanceof SqlType) {
                        type = (SqlType)annotation;
                    }
                    if (!(annotation instanceof Nullable)) continue;
                    nullableArgument = true;
                }
                Objects.requireNonNull(type, String.format("@SqlType annotation missing for argument to %s", method));
                if (Primitives.isWrapperType(parameterType)) {
                    Preconditions.checkArgument((boolean)nullableArgument, (String)"Method %s has parameter with type %s that is missing @Nullable", (Object[])new Object[]{method, parameterType});
                }
                if (typeParameterNames.contains((Object)type.value()) && (parameterType != Object.class || !nullableArgument)) {
                    Class<?> specialization = this.specializedTypeParameters.get(type.value());
                    Class nativeParameterType = Primitives.unwrap(parameterType);
                    Preconditions.checkArgument((specialization == null || specialization.equals(nativeParameterType) ? 1 : 0) != 0, (String)"%s has conflicting specializations %s and %s", (Object[])new Object[]{type.value(), specialization, nativeParameterType});
                    this.specializedTypeParameters.put(type.value(), nativeParameterType);
                }
                this.argumentNativeContainerTypes.add(parameterType);
                this.argumentTypes.add(TypeSignature.parseTypeSignature((String)type.value(), this.literalParameters));
                this.nullableArguments.add(nullableArgument);
            }
        }

        private Optional<MethodHandle> getConstructor(Method method, Map<Set<TypeParameter>, Constructor<?>> constructors) {
            if (Modifier.isStatic(method.getModifiers())) {
                return Optional.empty();
            }
            Constructor<?> constructor = constructors.get(this.typeParameters);
            Objects.requireNonNull(constructor, String.format("%s is an instance method and requires a public constructor to be declared with %s type parameters", method.getName(), this.typeParameters));
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                Annotation[] annotations = constructor.getParameterAnnotations()[i];
                Preconditions.checkArgument((boolean)Parser.containsMetaParameter(annotations), (Object)"Constructors may only have meta parameters");
                Preconditions.checkArgument((annotations.length == 1 ? 1 : 0) != 0, (Object)"Meta parameters may only have a single annotation");
                Annotation annotation = annotations[0];
                if (annotation instanceof TypeParameter) {
                    Preconditions.checkArgument((boolean)this.typeParameters.contains(annotation), (Object)"Injected type parameters must be declared with @TypeParameter annotation on the constructor");
                }
                this.constructorDependencies.add(Parser.parseDependency(annotation));
            }
            try {
                return Optional.of(MethodHandles.lookup().unreflectConstructor(constructor));
            }
            catch (IllegalAccessException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, (Throwable)e);
            }
        }

        private Map<String, Class<?>> getDeclaredSpecializedTypeParameters(Method method) {
            HashMap specializedTypeParameters = new HashMap();
            TypeParameterSpecialization[] typeParameterSpecializations = (TypeParameterSpecialization[])method.getAnnotationsByType(TypeParameterSpecialization.class);
            ImmutableSet typeParameterNames = this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableCollectors.toImmutableSet());
            for (TypeParameterSpecialization specialization : typeParameterSpecializations) {
                Preconditions.checkArgument((boolean)typeParameterNames.contains((Object)specialization.name()), (String)"%s does not match any declared type parameters (%s)", (Object[])new Object[]{specialization.name(), this.typeParameters});
                Class existingSpecialization = (Class)specializedTypeParameters.get(specialization.name());
                Preconditions.checkArgument((existingSpecialization == null || existingSpecialization.equals(specialization.nativeContainerType()) ? 1 : 0) != 0, (String)"%s has conflicting specializations %s and %s", (Object[])new Object[]{specialization.name(), existingSpecialization, specialization.nativeContainerType()});
                specializedTypeParameters.put(specialization.name(), specialization.nativeContainerType());
            }
            return specializedTypeParameters;
        }

        private MethodHandle getMethodHandle(Method method) {
            MethodHandle methodHandle;
            try {
                methodHandle = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, (Throwable)e);
            }
            if (!Modifier.isStatic(method.getModifiers())) {
                int i;
                int[] permutedIndices = new int[methodHandle.type().parameterCount()];
                permutedIndices[0] = this.dependencies.size();
                MethodType newType = methodHandle.type().changeParameterType(this.dependencies.size(), (Class<?>)methodHandle.type().parameterType(0));
                for (i = 0; i < this.dependencies.size(); ++i) {
                    permutedIndices[i + 1] = i;
                    newType = newType.changeParameterType(i, (Class<?>)methodHandle.type().parameterType(i + 1));
                }
                for (i = this.dependencies.size() + 1; i < permutedIndices.length; ++i) {
                    permutedIndices[i] = i;
                }
                methodHandle = MethodHandles.permuteArguments(methodHandle, newType, permutedIndices);
            }
            return methodHandle;
        }

        private static List<TypeVariableConstraint> createTypeVariableConstraints(Iterable<TypeParameter> typeParameters, List<ImplementationDependency> dependencies) {
            HashSet<String> orderableRequired = new HashSet<String>();
            HashSet<String> comparableRequired = new HashSet<String>();
            for (ImplementationDependency dependency : dependencies) {
                OperatorType operator;
                if (!(dependency instanceof OperatorImplementationDependency) || (operator = ((OperatorImplementationDependency)dependency).getOperator()) == OperatorType.CAST) continue;
                Set argumentTypes = (Set)((OperatorImplementationDependency)dependency).getSignature().getArgumentTypes().stream().map(TypeSignature::getBase).collect(ImmutableCollectors.toImmutableSet());
                Preconditions.checkArgument((argumentTypes.size() == 1 ? 1 : 0) != 0, (Object)"Operator dependency must only have arguments of a single type");
                String argumentType = (String)Iterables.getOnlyElement((Iterable)argumentTypes);
                if (COMPARABLE_TYPE_OPERATORS.contains((Object)operator)) {
                    comparableRequired.add(argumentType);
                }
                if (!ORDERABLE_TYPE_OPERATORS.contains((Object)operator)) continue;
                orderableRequired.add(argumentType);
            }
            ImmutableList.Builder typeVariableConstraints = ImmutableList.builder();
            for (TypeParameter typeParameter : typeParameters) {
                String name = typeParameter.value();
                if (orderableRequired.contains(name)) {
                    typeVariableConstraints.add((Object)Signature.orderableTypeParameter(name));
                    continue;
                }
                if (comparableRequired.contains(name)) {
                    typeVariableConstraints.add((Object)Signature.comparableTypeParameter(name));
                    continue;
                }
                typeVariableConstraints.add((Object)Signature.typeVariable(name));
            }
            return typeVariableConstraints.build();
        }

        private static ImplementationDependency parseDependency(Annotation annotation) {
            if (annotation instanceof TypeParameter) {
                return new TypeImplementationDependency(((TypeParameter)annotation).value());
            }
            if (annotation instanceof OperatorDependency) {
                OperatorDependency operator = (OperatorDependency)annotation;
                return new OperatorImplementationDependency(operator.operator(), TypeSignature.parseTypeSignature((String)operator.returnType()), (List)Arrays.asList(operator.argumentTypes()).stream().map(TypeSignature::parseTypeSignature).collect(ImmutableCollectors.toImmutableList()));
            }
            throw new IllegalArgumentException("Unsupported annotation " + annotation.getClass().getSimpleName());
        }

        private static boolean containsMetaParameter(Annotation[] annotations) {
            for (Annotation annotation : annotations) {
                if (annotation instanceof TypeParameter) {
                    return true;
                }
                if (!(annotation instanceof OperatorDependency)) continue;
                return true;
            }
            return false;
        }

        public ScalarImplementation get() {
            Signature signature = new Signature(this.functionName, FunctionKind.SCALAR, Parser.createTypeVariableConstraints(this.typeParameters, this.dependencies), this.longVariableConstraints, this.returnType, this.argumentTypes, false);
            return new ScalarImplementation(signature, this.nullable, this.nullableArguments, this.methodHandle, this.dependencies, this.constructorMethodHandle, this.constructorDependencies, this.argumentNativeContainerTypes, this.specializedTypeParameters);
        }

        public static ScalarImplementation parseImplementation(String functionName, Method method, Map<Set<TypeParameter>, Constructor<?>> constructors) {
            return new Parser(functionName, method, constructors).get();
        }
    }

    private static final class TypeImplementationDependency
    implements ImplementationDependency {
        private final TypeSignature signature;

        private TypeImplementationDependency(String signature) {
            this.signature = TypeSignature.parseTypeSignature((String)Objects.requireNonNull(signature, "signature is null"));
        }

        public Type resolve(Map<String, Type> types, TypeManager typeManager, FunctionRegistry functionRegistry) {
            return typeManager.getType(SignatureBinder.bindVariables(this.signature, new BoundVariables(types, (Map<String, Long>)ImmutableMap.of())));
        }
    }

    private static final class OperatorImplementationDependency
    implements ImplementationDependency {
        private final OperatorType operator;
        private final Signature signature;

        private OperatorImplementationDependency(OperatorType operator, TypeSignature returnType, List<TypeSignature> argumentTypes) {
            this.operator = Objects.requireNonNull(operator, "operator is null");
            Objects.requireNonNull(returnType, "returnType is null");
            Objects.requireNonNull(argumentTypes, "argumentTypes is null");
            this.signature = Signature.internalOperator(operator, returnType, argumentTypes);
        }

        public OperatorType getOperator() {
            return this.operator;
        }

        public Signature getSignature() {
            return this.signature;
        }

        @Override
        public MethodHandle resolve(Map<String, Type> types, TypeManager typeManager, FunctionRegistry functionRegistry) {
            Signature signature = SignatureBinder.bindVariables(this.signature, new BoundVariables(types, (Map<String, Long>)ImmutableMap.of()), this.signature.getArgumentTypes().size());
            return functionRegistry.getScalarFunctionImplementation(signature).getMethodHandle();
        }
    }

    private static interface ImplementationDependency {
        public Object resolve(Map<String, Type> var1, TypeManager var2, FunctionRegistry var3);
    }

    public static final class MethodHandleAndConstructor {
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> constructor;

        public MethodHandleAndConstructor(MethodHandle methodHandle, Optional<MethodHandle> constructor) {
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.constructor = Objects.requireNonNull(constructor, "constructor is null");
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        public Optional<MethodHandle> getConstructor() {
            return this.constructor;
        }
    }
}

