/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.annotations;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.scalar.ParametricScalar;
import com.facebook.presto.operator.scalar.annotations.ScalarImplementation;
import com.facebook.presto.operator.scalar.annotations.ScalarImplementationHeader;
import com.facebook.presto.operator.scalar.annotations.ScalarImplementations;
import com.facebook.presto.operator.scalar.annotations.TypeParameter;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ScalarFromAnnotationsParser {
    private ScalarFromAnnotationsParser() {
    }

    public static List<SqlScalarFunction> parseFunctionDefinition(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ScalarHeaderAndMethods scalar : ScalarFromAnnotationsParser.findScalarsInFunctionDefinitionClass(clazz)) {
            builder.add((Object)ScalarFromAnnotationsParser.parseParametricScalar(scalar, ScalarFromAnnotationsParser.findConstructors(clazz), clazz.getSimpleName()));
        }
        return builder.build();
    }

    public static List<SqlScalarFunction> parseFunctionDefinitions(Class<?> clazz) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ScalarHeaderAndMethods methods : ScalarFromAnnotationsParser.findScalarsInFunctionSetClass(clazz)) {
            builder.add((Object)ScalarFromAnnotationsParser.parseParametricScalar(methods, ScalarFromAnnotationsParser.findConstructors(clazz), clazz.getSimpleName()));
        }
        return builder.build();
    }

    private static List<ScalarHeaderAndMethods> findScalarsInFunctionDefinitionClass(Class annotated) {
        ImmutableList.Builder builder = ImmutableList.builder();
        List<ScalarImplementationHeader> classHeaders = ScalarImplementationHeader.fromAnnotatedElement(annotated);
        Preconditions.checkArgument((!classHeaders.isEmpty() ? 1 : 0) != 0, (Object)"Class that defines function must be annotated with @ScalarFunction or @ScalarOperator.");
        for (ScalarImplementationHeader header : classHeaders) {
            builder.add((Object)new ScalarHeaderAndMethods(header, ScalarFromAnnotationsParser.findPublicMethodsWithAnnotation(annotated, SqlType.class)));
        }
        return builder.build();
    }

    private static List<ScalarHeaderAndMethods> findScalarsInFunctionSetClass(Class annotated) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Method method : ScalarFromAnnotationsParser.findPublicMethodsWithAnnotation(annotated, SqlType.class)) {
            for (ScalarImplementationHeader header : ScalarImplementationHeader.fromAnnotatedElement(method)) {
                builder.add((Object)new ScalarHeaderAndMethods(header, (List<Method>)ImmutableList.of((Object)method)));
            }
        }
        return builder.build();
    }

    private static SqlScalarFunction parseParametricScalar(ScalarHeaderAndMethods scalar, Map<Set<TypeParameter>, Constructor<?>> constructors, String objectName) {
        ImmutableMap.Builder exactImplementations = ImmutableMap.builder();
        ImmutableList.Builder specializedImplementations = ImmutableList.builder();
        ImmutableList.Builder genericImplementations = ImmutableList.builder();
        Optional<Object> signature = Optional.empty();
        ScalarImplementationHeader header = scalar.getHeader();
        Preconditions.checkArgument((!header.getName().isEmpty() ? 1 : 0) != 0);
        for (Method method : scalar.getMethods()) {
            ScalarImplementation implementation = ScalarImplementation.Parser.parseImplementation(header.getName(), method, constructors);
            if (implementation.getSignature().getTypeVariableConstraints().isEmpty() && implementation.getSignature().getArgumentTypes().stream().noneMatch(TypeSignature::isCalculated) && !implementation.getSignature().getReturnType().isCalculated()) {
                exactImplementations.put((Object)implementation.getSignature(), (Object)implementation);
                continue;
            }
            if (implementation.hasSpecializedTypeParameters()) {
                specializedImplementations.add((Object)implementation);
            } else {
                genericImplementations.add((Object)implementation);
            }
            signature = signature.isPresent() ? signature : Optional.of(implementation.getSignature());
            ScalarFromAnnotationsParser.validateSignature(signature, implementation.getSignature());
        }
        ImmutableMap exactImplementationsMap = exactImplementations.build();
        if (!signature.isPresent()) {
            signature = Optional.of(((Map.Entry)Iterables.getOnlyElement(exactImplementationsMap.entrySet())).getKey());
        }
        ScalarImplementations implementations = new ScalarImplementations((Map<Signature, ScalarImplementation>)exactImplementations.build(), (List<ScalarImplementation>)specializedImplementations.build(), (List<ScalarImplementation>)genericImplementations.build());
        return new ParametricScalar((Signature)signature.get(), header.getHeader(), implementations);
    }

    private static void validateSignature(Optional<Signature> signatureOld, Signature signatureNew) {
        if (!signatureOld.isPresent()) {
            return;
        }
        Preconditions.checkArgument((boolean)signatureOld.get().equals(signatureNew), (String)"Implementations with type parameters must all have matching signatures. %s does not match %s", (Object[])new Object[]{signatureOld.get(), signatureNew});
    }

    private static Map<Set<TypeParameter>, Constructor<?>> findConstructors(Class<?> clazz) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Constructor<?> constructor : clazz.getConstructors()) {
            HashSet typeParameters = new HashSet();
            Stream.of(constructor.getAnnotationsByType(TypeParameter.class)).forEach(typeParameters::add);
            builder.put(typeParameters, constructor);
        }
        return builder.build();
    }

    private static List<Method> findPublicMethodsWithAnnotation(Class<?> clazz, Class<?> annotationClass) {
        ImmutableList.Builder methods = ImmutableList.builder();
        for (Method method : clazz.getMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotationClass.isInstance(annotation)) continue;
                Preconditions.checkArgument((boolean)Modifier.isPublic(method.getModifiers()), (String)"%s annotated with %s must be public", (Object[])new Object[]{method.getName(), annotationClass.getSimpleName()});
                methods.add((Object)method);
            }
        }
        return methods.build();
    }

    private static class ScalarHeaderAndMethods {
        private final ScalarImplementationHeader header;
        private final List<Method> methods;

        public ScalarHeaderAndMethods(ScalarImplementationHeader header, List<Method> methods) {
            this.header = Objects.requireNonNull(header);
            this.methods = Objects.requireNonNull(methods);
        }

        public ScalarImplementationHeader getHeader() {
            return this.header;
        }

        public List<Method> getMethods() {
            return this.methods;
        }
    }
}

