/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;

public class VarcharToVarcharCast
extends SqlOperator {
    private static final MethodHandle TRUNCATE_METHOD_HANDLE = Reflection.methodHandle(VarcharToVarcharCast.class, "truncate", Slice.class, Integer.TYPE);
    public static final VarcharToVarcharCast VARCHAR_TO_VARCHAR_CAST = new VarcharToVarcharCast();

    private VarcharToVarcharCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableWithVariadicBound("F", "varchar"), (Object)Signature.comparableWithVariadicBound("T", "varchar")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"F")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        VarcharType fromType = (VarcharType)boundVariables.getTypeVariable("F");
        VarcharType toType = (VarcharType)boundVariables.getTypeVariable("T");
        MethodHandle methodHandle = VarcharToVarcharCast.getMethodHandle(fromType, toType);
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false), methodHandle, true);
    }

    private static MethodHandle getMethodHandle(VarcharType fromType, VarcharType toType) {
        if (toType.getLength() < fromType.getLength()) {
            return MethodHandles.insertArguments(TRUNCATE_METHOD_HANDLE, 1, toType.getLength());
        }
        return MethodHandles.identity(Slice.class);
    }

    public static Slice truncate(Slice slice, int length) {
        if (length < 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Length smaller then zero");
        }
        return Varchars.truncateToLength((Slice)slice, (int)length);
    }
}

