/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Base64;

public final class VarbinaryFunctions {
    private VarbinaryFunctions() {
    }

    @Description(value="length of the given binary")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long length(@SqlType(value="varbinary") Slice slice) {
        return slice.length();
    }

    @Description(value="encode binary data as base64")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice toBase64(@SqlType(value="varbinary") Slice slice) {
        return Slices.wrappedBuffer((byte[])Base64.getEncoder().encode(slice.getBytes()));
    }

    @Description(value="decode base64 encoded binary data")
    @ScalarFunction(value="from_base64")
    @SqlType(value="varbinary")
    public static Slice fromBase64Varchar(@SqlType(value="varchar") Slice slice) {
        try {
            return Slices.wrappedBuffer((byte[])Base64.getDecoder().decode(slice.getBytes()));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @Description(value="decode base64 encoded binary data")
    @ScalarFunction(value="from_base64")
    @SqlType(value="varbinary")
    public static Slice fromBase64Varbinary(@SqlType(value="varbinary") Slice slice) {
        try {
            return Slices.wrappedBuffer((byte[])Base64.getDecoder().decode(slice.getBytes()));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @Description(value="encode binary data as base64 using the URL safe alphabet")
    @ScalarFunction(value="to_base64url")
    @SqlType(value="varchar")
    public static Slice toBase64Url(@SqlType(value="varbinary") Slice slice) {
        return Slices.wrappedBuffer((byte[])Base64.getUrlEncoder().encode(slice.getBytes()));
    }

    @Description(value="decode URL safe base64 encoded binary data")
    @ScalarFunction(value="from_base64url")
    @SqlType(value="varbinary")
    public static Slice fromBase64UrlVarchar(@SqlType(value="varchar") Slice slice) {
        try {
            return Slices.wrappedBuffer((byte[])Base64.getUrlDecoder().decode(slice.getBytes()));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @Description(value="decode URL safe base64 encoded binary data")
    @ScalarFunction(value="from_base64url")
    @SqlType(value="varbinary")
    public static Slice fromBase64UrlVarbinary(@SqlType(value="varbinary") Slice slice) {
        try {
            return Slices.wrappedBuffer((byte[])Base64.getUrlDecoder().decode(slice.getBytes()));
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    @Description(value="encode binary data as hex")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice toHex(@SqlType(value="varbinary") Slice slice) {
        return Slices.utf8Slice((String)BaseEncoding.base16().encode(slice.getBytes()));
    }

    @Description(value="decode hex encoded binary data")
    @ScalarFunction(value="from_hex")
    @SqlType(value="varbinary")
    public static Slice fromHexVarchar(@SqlType(value="varchar") Slice slice) {
        if (slice.length() % 2 != 0) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "invalid input length " + slice.length());
        }
        byte[] result = new byte[slice.length() / 2];
        for (int i = 0; i < slice.length(); i += 2) {
            result[i / 2] = (byte)(VarbinaryFunctions.hexDigitCharToInt(slice.getByte(i)) << 4 | VarbinaryFunctions.hexDigitCharToInt(slice.getByte(i + 1)));
        }
        return Slices.wrappedBuffer((byte[])result);
    }

    @Description(value="compute md5 hash")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice md5(@SqlType(value="varbinary") Slice slice) {
        return Slices.wrappedBuffer((byte[])Hashing.md5().hashBytes(slice.getBytes()).asBytes());
    }

    @Description(value="compute sha1 hash")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice sha1(@SqlType(value="varbinary") Slice slice) {
        return Slices.wrappedBuffer((byte[])Hashing.sha1().hashBytes(slice.getBytes()).asBytes());
    }

    @Description(value="compute sha256 hash")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice sha256(@SqlType(value="varbinary") Slice slice) {
        return Slices.wrappedBuffer((byte[])Hashing.sha256().hashBytes(slice.getBytes()).asBytes());
    }

    @Description(value="compute sha512 hash")
    @ScalarFunction
    @SqlType(value="varbinary")
    public static Slice sha512(@SqlType(value="varbinary") Slice slice) {
        return Slices.wrappedBuffer((byte[])Hashing.sha512().hashBytes(slice.getBytes()).asBytes());
    }

    private static int hexDigitCharToInt(byte b) {
        if (b >= 48 && b <= 57) {
            return b - 48;
        }
        if (b >= 97 && b <= 102) {
            return b - 97 + 10;
        }
        if (b >= 65 && b <= 70) {
            return b - 65 + 10;
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "invalid hex character: " + (char)b);
    }

    @Description(value="decode hex encoded binary data")
    @ScalarFunction(value="from_hex")
    @SqlType(value="varbinary")
    public static Slice fromHexVarbinary(@SqlType(value="varbinary") Slice slice) {
        return VarbinaryFunctions.fromHexVarchar(slice);
    }
}

