/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;

public class TryCastFunction
extends SqlScalarFunction {
    public static final TryCastFunction TRY_CAST = new TryCastFunction();

    public TryCastFunction() {
        super(new Signature("TRY_CAST", FunctionKind.SCALAR, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("F"), (Object)Signature.typeVariable("T")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"T"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"F")), false));
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean isDeterministic() {
        return true;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        MethodHandle tryCastHandle;
        Type fromType = boundVariables.getTypeVariable("F");
        Type toType = boundVariables.getTypeVariable("T");
        Class returnType = Primitives.wrap((Class)toType.getJavaType());
        if (fromType.equals((Object)UnknownType.UNKNOWN)) {
            tryCastHandle = MethodHandles.dropArguments(MethodHandles.constant(returnType, null), 0, new Class[]{Void.class});
        } else {
            Signature signature = functionRegistry.getCoercion(fromType, toType);
            MethodHandle coercion = functionRegistry.getScalarFunctionImplementation(signature).getMethodHandle();
            coercion = coercion.asType(MethodType.methodType(returnType, coercion.type()));
            MethodHandle exceptionHandler = MethodHandles.dropArguments(MethodHandles.constant(returnType, null), 0, new Class[]{RuntimeException.class});
            tryCastHandle = MethodHandles.catchException(coercion, RuntimeException.class, exceptionHandler);
        }
        return new ScalarFunctionImplementation(true, (List<Boolean>)ImmutableList.of((Object)true), tryCastHandle, this.isDeterministic());
    }
}

