/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.type.Re2JRegexp;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class Re2JCastToRegexpFunction
extends SqlOperator {
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(Re2JCastToRegexpFunction.class, "castToRegexp", Integer.TYPE, Integer.TYPE, Slice.class);
    private final int dfaStatesLimit;
    private final int dfaRetries;

    public Re2JCastToRegexpFunction(int dfaStatesLimit, int dfaRetries) {
        super(OperatorType.CAST, Collections.emptyList(), Collections.emptyList(), TypeSignature.parseTypeSignature((String)"Re2JRegExp"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"varchar(x)", (Set)ImmutableSet.of((Object)"x"))));
        this.dfaStatesLimit = dfaStatesLimit;
        this.dfaRetries = dfaRetries;
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        return new ScalarFunctionImplementation(false, (List<Boolean>)ImmutableList.of((Object)false), MethodHandles.insertArguments(METHOD_HANDLE, 0, this.dfaStatesLimit, this.dfaRetries), true);
    }

    public static Re2JRegexp castToRegexp(int dfaStatesLimit, int dfaRetries, Slice pattern) {
        try {
            return new Re2JRegexp(dfaStatesLimit, dfaRetries, pattern);
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }
}

