/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.type.SqlType;
import com.facebook.presto.util.Failures;
import com.google.common.primitives.Doubles;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.concurrent.ThreadLocalRandom;

public final class MathFunctions {
    private MathFunctions() {
    }

    @Description(value="absolute value")
    @ScalarFunction(value="abs")
    @SqlType(value="tinyint")
    public static long absTinyint(@SqlType(value="tinyint") long num) {
        Failures.checkCondition(num != -128L, (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Value -128 is out of range for abs(tinyint)", new Object[0]);
        return Math.abs(num);
    }

    @Description(value="absolute value")
    @ScalarFunction(value="abs")
    @SqlType(value="smallint")
    public static long absSmallint(@SqlType(value="smallint") long num) {
        Failures.checkCondition(num != -32768L, (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Value -32768 is out of range for abs(smallint)", new Object[0]);
        return Math.abs(num);
    }

    @Description(value="absolute value")
    @ScalarFunction(value="abs")
    @SqlType(value="integer")
    public static long absInteger(@SqlType(value="integer") long num) {
        Failures.checkCondition(num != Integer.MIN_VALUE, (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Value -2147483648 is out of range for abs(integer)", new Object[0]);
        return Math.abs(num);
    }

    @Description(value="absolute value")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long abs(@SqlType(value="bigint") long num) {
        Failures.checkCondition(num != Long.MIN_VALUE, (ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, "Value -9223372036854775808 is out of range for abs(bigint)", new Object[0]);
        return Math.abs(num);
    }

    @Description(value="absolute value")
    @ScalarFunction
    @SqlType(value="double")
    public static double abs(@SqlType(value="double") double num) {
        return Math.abs(num);
    }

    @Description(value="arc cosine")
    @ScalarFunction
    @SqlType(value="double")
    public static double acos(@SqlType(value="double") double num) {
        return Math.acos(num);
    }

    @Description(value="arc sine")
    @ScalarFunction
    @SqlType(value="double")
    public static double asin(@SqlType(value="double") double num) {
        return Math.asin(num);
    }

    @Description(value="arc tangent")
    @ScalarFunction
    @SqlType(value="double")
    public static double atan(@SqlType(value="double") double num) {
        return Math.atan(num);
    }

    @Description(value="arc tangent of given fraction")
    @ScalarFunction
    @SqlType(value="double")
    public static double atan2(@SqlType(value="double") double num1, @SqlType(value="double") double num2) {
        return Math.atan2(num1, num2);
    }

    @Description(value="cube root")
    @ScalarFunction
    @SqlType(value="double")
    public static double cbrt(@SqlType(value="double") double num) {
        return Math.cbrt(num);
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(value="ceiling", alias={"ceil"})
    @SqlType(value="tinyint")
    public static long ceilingTinyint(@SqlType(value="tinyint") long num) {
        return num;
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(value="ceiling", alias={"ceil"})
    @SqlType(value="smallint")
    public static long ceilingSmallint(@SqlType(value="smallint") long num) {
        return num;
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(value="ceiling", alias={"ceil"})
    @SqlType(value="integer")
    public static long ceilingInteger(@SqlType(value="integer") long num) {
        return num;
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(alias={"ceil"})
    @SqlType(value="bigint")
    public static long ceiling(@SqlType(value="bigint") long num) {
        return num;
    }

    @Description(value="round up to nearest integer")
    @ScalarFunction(alias={"ceil"})
    @SqlType(value="double")
    public static double ceiling(@SqlType(value="double") double num) {
        return Math.ceil(num);
    }

    @Description(value="round to integer by dropping digits after decimal point")
    @ScalarFunction
    @SqlType(value="double")
    public static double truncate(@SqlType(value="double") double num) {
        return Math.signum(num) * Math.floor(Math.abs(num));
    }

    @Description(value="cosine")
    @ScalarFunction
    @SqlType(value="double")
    public static double cos(@SqlType(value="double") double num) {
        return Math.cos(num);
    }

    @Description(value="hyperbolic cosine")
    @ScalarFunction
    @SqlType(value="double")
    public static double cosh(@SqlType(value="double") double num) {
        return Math.cosh(num);
    }

    @Description(value="converts an angle in radians to degrees")
    @ScalarFunction
    @SqlType(value="double")
    public static double degrees(@SqlType(value="double") double radians) {
        return Math.toDegrees(radians);
    }

    @Description(value="Euler's number")
    @ScalarFunction
    @SqlType(value="double")
    public static double e() {
        return Math.E;
    }

    @Description(value="Euler's number raised to the given power")
    @ScalarFunction
    @SqlType(value="double")
    public static double exp(@SqlType(value="double") double num) {
        return Math.exp(num);
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction(value="floor")
    @SqlType(value="tinyint")
    public static long floorTinyint(@SqlType(value="tinyint") long num) {
        return num;
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction(value="floor")
    @SqlType(value="smallint")
    public static long floorSmallint(@SqlType(value="smallint") long num) {
        return num;
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction(value="floor")
    @SqlType(value="integer")
    public static long floorInteger(@SqlType(value="integer") long num) {
        return num;
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long floor(@SqlType(value="bigint") long num) {
        return num;
    }

    @Description(value="round down to nearest integer")
    @ScalarFunction
    @SqlType(value="double")
    public static double floor(@SqlType(value="double") double num) {
        return Math.floor(num);
    }

    @Description(value="natural logarithm")
    @ScalarFunction
    @SqlType(value="double")
    public static double ln(@SqlType(value="double") double num) {
        return Math.log(num);
    }

    @Description(value="logarithm to base 2")
    @ScalarFunction
    @SqlType(value="double")
    public static double log2(@SqlType(value="double") double num) {
        return Math.log(num) / Math.log(2.0);
    }

    @Description(value="logarithm to base 10")
    @ScalarFunction
    @SqlType(value="double")
    public static double log10(@SqlType(value="double") double num) {
        return Math.log10(num);
    }

    @Description(value="logarithm to given base")
    @ScalarFunction
    @SqlType(value="double")
    public static double log(@SqlType(value="double") double num, @SqlType(value="double") double base) {
        return Math.log(num) / Math.log(base);
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction(value="mod")
    @SqlType(value="tinyint")
    public static long modTinyint(@SqlType(value="tinyint") long num1, @SqlType(value="tinyint") long num2) {
        return num1 % num2;
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction(value="mod")
    @SqlType(value="smallint")
    public static long modSmallint(@SqlType(value="smallint") long num1, @SqlType(value="smallint") long num2) {
        return num1 % num2;
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction(value="mod")
    @SqlType(value="integer")
    public static long modInteger(@SqlType(value="integer") long num1, @SqlType(value="integer") long num2) {
        return num1 % num2;
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long mod(@SqlType(value="bigint") long num1, @SqlType(value="bigint") long num2) {
        return num1 % num2;
    }

    @Description(value="remainder of given quotient")
    @ScalarFunction
    @SqlType(value="double")
    public static double mod(@SqlType(value="double") double num1, @SqlType(value="double") double num2) {
        return num1 % num2;
    }

    @Description(value="the constant Pi")
    @ScalarFunction
    @SqlType(value="double")
    public static double pi() {
        return Math.PI;
    }

    @Description(value="value raised to the power of exponent")
    @ScalarFunction(alias={"pow"})
    @SqlType(value="double")
    public static double power(@SqlType(value="double") double num, @SqlType(value="double") double exponent) {
        return Math.pow(num, exponent);
    }

    @Description(value="converts an angle in degrees to radians")
    @ScalarFunction
    @SqlType(value="double")
    public static double radians(@SqlType(value="double") double degrees) {
        return Math.toRadians(degrees);
    }

    @Description(value="a pseudo-random value")
    @ScalarFunction(alias={"rand"}, deterministic=false)
    @SqlType(value="double")
    public static double random() {
        return ThreadLocalRandom.current().nextDouble();
    }

    @Description(value="a pseudo-random number between 0 and value (exclusive)")
    @ScalarFunction(value="random", alias={"rand"}, deterministic=false)
    @SqlType(value="tinyint")
    public static long randomTinyint(@SqlType(value="tinyint") long value) {
        Failures.checkCondition(value > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "bound must be positive", new Object[0]);
        return ThreadLocalRandom.current().nextInt((int)value);
    }

    @Description(value="a pseudo-random number between 0 and value (exclusive)")
    @ScalarFunction(value="random", alias={"rand"}, deterministic=false)
    @SqlType(value="smallint")
    public static long randomSmallint(@SqlType(value="smallint") long value) {
        Failures.checkCondition(value > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "bound must be positive", new Object[0]);
        return ThreadLocalRandom.current().nextInt((int)value);
    }

    @Description(value="a pseudo-random number between 0 and value (exclusive)")
    @ScalarFunction(value="random", alias={"rand"}, deterministic=false)
    @SqlType(value="integer")
    public static long randomInteger(@SqlType(value="integer") long value) {
        Failures.checkCondition(value > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "bound must be positive", new Object[0]);
        return ThreadLocalRandom.current().nextInt((int)value);
    }

    @Description(value="a pseudo-random number between 0 and value (exclusive)")
    @ScalarFunction(alias={"rand"}, deterministic=false)
    @SqlType(value="bigint")
    public static long random(@SqlType(value="bigint") long value) {
        Failures.checkCondition(value > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "bound must be positive", new Object[0]);
        return ThreadLocalRandom.current().nextLong(value);
    }

    @Description(value="round to nearest integer")
    @ScalarFunction(value="round")
    @SqlType(value="tinyint")
    public static long roundTinyint(@SqlType(value="tinyint") long num) {
        return num;
    }

    @Description(value="round to nearest integer")
    @ScalarFunction(value="round")
    @SqlType(value="smallint")
    public static long roundSmallint(@SqlType(value="smallint") long num) {
        return num;
    }

    @Description(value="round to nearest integer")
    @ScalarFunction(value="round")
    @SqlType(value="integer")
    public static long roundInteger(@SqlType(value="integer") long num) {
        return num;
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long round(@SqlType(value="bigint") long num) {
        return MathFunctions.round(num, 0L);
    }

    @Description(value="round to nearest integer")
    @ScalarFunction(value="round")
    @SqlType(value="tinyint")
    public static long roundTinyint(@SqlType(value="tinyint") long num, @SqlType(value="bigint") long decimals) {
        return num;
    }

    @Description(value="round to nearest integer")
    @ScalarFunction(value="round")
    @SqlType(value="smallint")
    public static long roundSmallint(@SqlType(value="smallint") long num, @SqlType(value="bigint") long decimals) {
        return num;
    }

    @Description(value="round to nearest integer")
    @ScalarFunction(value="round")
    @SqlType(value="integer")
    public static long roundInteger(@SqlType(value="integer") long num, @SqlType(value="bigint") long decimals) {
        return num;
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long round(@SqlType(value="bigint") long num, @SqlType(value="bigint") long decimals) {
        return num;
    }

    @Description(value="round to nearest integer")
    @ScalarFunction
    @SqlType(value="double")
    public static double round(@SqlType(value="double") double num) {
        return MathFunctions.round(num, 0L);
    }

    @Description(value="round to given number of decimal places")
    @ScalarFunction
    @SqlType(value="double")
    public static double round(@SqlType(value="double") double num, @SqlType(value="bigint") long decimals) {
        if (Double.isNaN(num) || Double.isInfinite(num)) {
            return num;
        }
        double factor = Math.pow(10.0, decimals);
        if (num < 0.0) {
            return -((double)Math.round(-num * factor) / factor);
        }
        return (double)Math.round(num * factor) / factor;
    }

    @Description(value="signum")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long sign(@SqlType(value="bigint") long num) {
        return (long)Math.signum(num);
    }

    @Description(value="signum")
    @ScalarFunction(value="sign")
    @SqlType(value="integer")
    public static long signInteger(@SqlType(value="integer") long num) {
        return (long)Math.signum(num);
    }

    @Description(value="signum")
    @ScalarFunction(value="sign")
    @SqlType(value="smallint")
    public static long signSmallint(@SqlType(value="smallint") long num) {
        return (long)Math.signum(num);
    }

    @Description(value="signum")
    @ScalarFunction(value="sign")
    @SqlType(value="tinyint")
    public static long signTinyint(@SqlType(value="tinyint") long num) {
        return (long)Math.signum(num);
    }

    @Description(value="signum")
    @ScalarFunction
    @SqlType(value="double")
    public static double sign(@SqlType(value="double") double num) {
        return Math.signum(num);
    }

    @Description(value="sine")
    @ScalarFunction
    @SqlType(value="double")
    public static double sin(@SqlType(value="double") double num) {
        return Math.sin(num);
    }

    @Description(value="square root")
    @ScalarFunction
    @SqlType(value="double")
    public static double sqrt(@SqlType(value="double") double num) {
        return Math.sqrt(num);
    }

    @Description(value="tangent")
    @ScalarFunction
    @SqlType(value="double")
    public static double tan(@SqlType(value="double") double num) {
        return Math.tan(num);
    }

    @Description(value="hyperbolic tangent")
    @ScalarFunction
    @SqlType(value="double")
    public static double tanh(@SqlType(value="double") double num) {
        return Math.tanh(num);
    }

    @Description(value="test if value is not-a-number")
    @ScalarFunction(value="is_nan")
    @SqlType(value="boolean")
    public static boolean isNaN(@SqlType(value="double") double num) {
        return Double.isNaN(num);
    }

    @Description(value="test if value is finite")
    @ScalarFunction
    @SqlType(value="boolean")
    public static boolean isFinite(@SqlType(value="double") double num) {
        return Doubles.isFinite((double)num);
    }

    @Description(value="test if value is infinite")
    @ScalarFunction
    @SqlType(value="boolean")
    public static boolean isInfinite(@SqlType(value="double") double num) {
        return Double.isInfinite(num);
    }

    @Description(value="constant representing not-a-number")
    @ScalarFunction(value="nan")
    @SqlType(value="double")
    public static double NaN() {
        return Double.NaN;
    }

    @Description(value="Infinity")
    @ScalarFunction
    @SqlType(value="double")
    public static double infinity() {
        return Double.POSITIVE_INFINITY;
    }

    @Description(value="convert a number to a string in the given base")
    @ScalarFunction
    @SqlType(value="varchar")
    public static Slice toBase(@SqlType(value="bigint") long value, @SqlType(value="bigint") long radix) {
        MathFunctions.checkRadix(radix);
        return Slices.utf8Slice((String)Long.toString(value, (int)radix));
    }

    @Description(value="convert a string in the given base to a number")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long fromBase(@SqlType(value="varchar") Slice value, @SqlType(value="bigint") long radix) {
        MathFunctions.checkRadix(radix);
        try {
            return Long.parseLong(value.toStringUtf8(), (int)radix);
        }
        catch (NumberFormatException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Not a valid base-%d number: %s", radix, value.toStringUtf8()), (Throwable)e);
        }
    }

    private static void checkRadix(long radix) {
        Failures.checkCondition(radix >= 2L && radix <= 36L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Radix must be between %d and %d", 2, 36);
    }

    @Description(value="The bucket number of a value given a lower and upper bound and the number of buckets")
    @ScalarFunction(value="width_bucket")
    @SqlType(value="bigint")
    public static long widthBucket(@SqlType(value="double") double operand, @SqlType(value="double") double bound1, @SqlType(value="double") double bound2, @SqlType(value="bigint") long bucketCount) {
        Failures.checkCondition(bucketCount > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "bucketCount must be greater than 0", new Object[0]);
        Failures.checkCondition(!MathFunctions.isNaN(operand), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "operand must not be NaN", new Object[0]);
        Failures.checkCondition(MathFunctions.isFinite(bound1), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "first bound must be finite", new Object[0]);
        Failures.checkCondition(MathFunctions.isFinite(bound2), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second bound must be finite", new Object[0]);
        Failures.checkCondition(bound1 != bound2, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "bounds cannot equal each other", new Object[0]);
        long result = 0L;
        double lower = Math.min(bound1, bound2);
        double upper = Math.max(bound1, bound2);
        if (operand < lower) {
            result = 0L;
        } else if (operand >= upper) {
            try {
                result = Math.addExact(bucketCount, 1L);
            }
            catch (ArithmeticException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE, String.format("Bucket for value %s is out of range", operand));
            }
        } else {
            result = (long)((double)bucketCount * (operand - lower) / (upper - lower) + 1.0);
        }
        if (bound1 > bound2) {
            result = bucketCount - result + 1L;
        }
        return result;
    }

    @Description(value="The bucket number of a value given an array of bins")
    @ScalarFunction(value="width_bucket")
    @SqlType(value="bigint")
    public static long widthBucket(@SqlType(value="double") double operand, @SqlType(value="array(double)") Block bins) {
        int numberOfBins = bins.getPositionCount();
        Failures.checkCondition(numberOfBins > 0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Bins cannot be an empty array", new Object[0]);
        Failures.checkCondition(!MathFunctions.isNaN(operand), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Operand cannot be NaN", new Object[0]);
        int lower = 0;
        int upper = numberOfBins;
        while (lower < upper) {
            if (DoubleType.DOUBLE.getDouble(bins, lower) > DoubleType.DOUBLE.getDouble(bins, upper - 1)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Bin values are not sorted in ascending order");
            }
            int index = (lower + upper) / 2;
            double bin = DoubleType.DOUBLE.getDouble(bins, index);
            Failures.checkCondition(MathFunctions.isFinite(bin), (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Bin value must be finite, got %s", bin), new Object[0]);
            if (operand < bin) {
                upper = index;
                continue;
            }
            lower = index + 1;
        }
        return lower;
    }
}

