/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;

public class MapSubscriptOperator
extends SqlOperator {
    public static final MapSubscriptOperator MAP_SUBSCRIPT = new MapSubscriptOperator();
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", MethodHandle.class, Type.class, Type.class, Block.class, Boolean.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", MethodHandle.class, Type.class, Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", MethodHandle.class, Type.class, Type.class, Block.class, Double.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", MethodHandle.class, Type.class, Type.class, Block.class, Slice.class);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(MapSubscriptOperator.class, "subscript", MethodHandle.class, Type.class, Type.class, Block.class, Object.class);

    protected MapSubscriptOperator() {
        super(OperatorType.SUBSCRIPT, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("K"), (Object)Signature.typeVariable("V")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"V"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(K,V)"), (Object)TypeSignature.parseTypeSignature((String)"K")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type keyType = boundVariables.getTypeVariable("K");
        Type valueType = boundVariables.getTypeVariable("V");
        MethodHandle keyEqualsMethod = functionRegistry.getScalarFunctionImplementation(Signature.internalOperator(OperatorType.EQUAL, (Type)BooleanType.BOOLEAN, (List<? extends Type>)ImmutableList.of((Object)keyType, (Object)keyType))).getMethodHandle();
        MethodHandle methodHandle = keyType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (keyType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (keyType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (keyType.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT)));
        methodHandle = methodHandle.bindTo(keyEqualsMethod).bindTo(keyType).bindTo(valueType);
        methodHandle = valueType.getJavaType() == Void.TYPE ? methodHandle.asType(methodHandle.type().changeReturnType(Void.TYPE)) : methodHandle.asType(methodHandle.type().changeReturnType(Primitives.wrap((Class)valueType.getJavaType())));
        return new ScalarFunctionImplementation(true, (List<Boolean>)ImmutableList.of((Object)false, (Object)false), methodHandle, this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static Object subscript(MethodHandle keyEqualsMethod, Type keyType, Type valueType, Block map, boolean key) {
        for (int position = 0; position < map.getPositionCount(); position += 2) {
            try {
                if (!keyEqualsMethod.invokeExact(keyType.getBoolean(map, position), key)) continue;
                return TypeUtils.readNativeValue((Type)valueType, (Block)map, (int)(position + 1));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return null;
    }

    @UsedByGeneratedCode
    public static Object subscript(MethodHandle keyEqualsMethod, Type keyType, Type valueType, Block map, long key) {
        for (int position = 0; position < map.getPositionCount(); position += 2) {
            try {
                if (!keyEqualsMethod.invokeExact(keyType.getLong(map, position), key)) continue;
                return TypeUtils.readNativeValue((Type)valueType, (Block)map, (int)(position + 1));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return null;
    }

    @UsedByGeneratedCode
    public static Object subscript(MethodHandle keyEqualsMethod, Type keyType, Type valueType, Block map, double key) {
        for (int position = 0; position < map.getPositionCount(); position += 2) {
            try {
                if (!keyEqualsMethod.invokeExact(keyType.getDouble(map, position), key)) continue;
                return TypeUtils.readNativeValue((Type)valueType, (Block)map, (int)(position + 1));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return null;
    }

    @UsedByGeneratedCode
    public static Object subscript(MethodHandle keyEqualsMethod, Type keyType, Type valueType, Block map, Slice key) {
        for (int position = 0; position < map.getPositionCount(); position += 2) {
            try {
                if (!keyEqualsMethod.invokeExact(keyType.getSlice(map, position), key)) continue;
                return TypeUtils.readNativeValue((Type)valueType, (Block)map, (int)(position + 1));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return null;
    }

    @UsedByGeneratedCode
    public static Object subscript(MethodHandle keyEqualsMethod, Type keyType, Type valueType, Block map, Object key) {
        for (int position = 0; position < map.getPositionCount(); position += 2) {
            try {
                if (!keyEqualsMethod.invoke(keyType.getObject(map, position), key)) continue;
                return TypeUtils.readNativeValue((Type)valueType, (Block)map, (int)(position + 1));
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return null;
    }
}

