/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.operator.scalar.annotations.TypeParameter;
import com.facebook.presto.operator.scalar.annotations.TypeParameterContainer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.SqlType;

@ScalarFunction(value="map_keys")
@Description(value="Returns the keys of the given map(K,V) as an array")
public final class MapKeys {
    private MapKeys() {
    }

    @TypeParameterContainer(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="array(K)")
    public static Block getKeys(@TypeParameter(value="K") Type keyType, @SqlType(value="map(K,V)") Block block) {
        BlockBuilder blockBuilder = keyType.createBlockBuilder(new BlockBuilderStatus(), block.getPositionCount() / 2);
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            keyType.appendTo(block, i, blockBuilder);
        }
        return blockBuilder.build();
    }
}

