/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.operator.scalar.annotations.TypeParameter;
import com.facebook.presto.operator.scalar.annotations.TypeParameterContainer;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.InterleavedBlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.SqlType;
import com.google.common.collect.ImmutableList;
import java.util.List;

@ScalarFunction(value="map_concat")
@Description(value="Concatenates given maps")
public final class MapConcatFunction {
    private MapConcatFunction() {
    }

    @TypeParameterContainer(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="map(K,V)")
    public static Block mapConcat(@TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType, @SqlType(value="map(K,V)") Block leftMap, @SqlType(value="map(K,V)") Block rightMap) {
        int i;
        TypedSet typedSet = new TypedSet(keyType, rightMap.getPositionCount());
        InterleavedBlockBuilder blockBuilder = new InterleavedBlockBuilder((List)ImmutableList.of((Object)keyType, (Object)valueType), new BlockBuilderStatus(), leftMap.getPositionCount() + rightMap.getPositionCount());
        for (i = 0; i < rightMap.getPositionCount(); i += 2) {
            typedSet.add(rightMap, i);
            keyType.appendTo(rightMap, i, (BlockBuilder)blockBuilder);
            valueType.appendTo(rightMap, i + 1, (BlockBuilder)blockBuilder);
        }
        for (i = 0; i < leftMap.getPositionCount(); i += 2) {
            if (typedSet.contains(leftMap, i)) continue;
            keyType.appendTo(leftMap, i, (BlockBuilder)blockBuilder);
            valueType.appendTo(leftMap, i + 1, (BlockBuilder)blockBuilder);
        }
        return blockBuilder.build();
    }
}

