/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;

public final class CastFromUnknownOperator
extends SqlOperator {
    public static final CastFromUnknownOperator CAST_FROM_UNKNOWN = new CastFromUnknownOperator();
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(CastFromUnknownOperator.class, "toLong", Void.class);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(CastFromUnknownOperator.class, "toDouble", Void.class);
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(CastFromUnknownOperator.class, "toBoolean", Void.class);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(CastFromUnknownOperator.class, "toSlice", Void.class);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(CastFromUnknownOperator.class, "toObject", Void.class);

    public CastFromUnknownOperator() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("E")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"E"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"unknown")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Type toType = boundVariables.getTypeVariable("E");
        MethodHandle methodHandle = toType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (toType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (toType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (toType.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT.asType(METHOD_HANDLE_OBJECT.type().changeReturnType(toType.getJavaType())))));
        return new ScalarFunctionImplementation(true, (List<Boolean>)ImmutableList.of((Object)true), methodHandle, this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static Long toLong(Void arg) {
        return null;
    }

    @UsedByGeneratedCode
    public static Double toDouble(Void arg) {
        return null;
    }

    @UsedByGeneratedCode
    public static Boolean toBoolean(Void arg) {
        return null;
    }

    @UsedByGeneratedCode
    public static Slice toSlice(Void arg) {
        return null;
    }

    @UsedByGeneratedCode
    public static Object toObject(Void arg) {
        return null;
    }
}

