/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.SqlType;

public final class BitwiseFunctions {
    private BitwiseFunctions() {
    }

    @Description(value="count number of set bits in 2's complement representation")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitCount(@SqlType(value="bigint") long num, @SqlType(value="bigint") long bits) {
        if (bits == 64L) {
            return Long.bitCount(num);
        }
        if (bits <= 1L || bits > 64L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Bits specified in bit_count must be between 2 and 64, got " + bits);
        }
        long lowBitsMask = (1 << (int)(bits - 1L)) - 1;
        if (num > lowBitsMask || num < (lowBitsMask ^ 0xFFFFFFFFFFFFFFFFL)) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Number must be representable with the bits specified. " + num + " can not be represented with " + bits + " bits");
        }
        long mask = lowBitsMask | Long.MIN_VALUE;
        return Long.bitCount(num & mask);
    }

    @Description(value="bitwise NOT in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseNot(@SqlType(value="bigint") long num) {
        return num ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Description(value="bitwise AND in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseAnd(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left & right;
    }

    @Description(value="bitwise OR in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseOr(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left | right;
    }

    @Description(value="bitwise XOR in 2's complement arithmetic")
    @ScalarFunction
    @SqlType(value="bigint")
    public static long bitwiseXor(@SqlType(value="bigint") long left, @SqlType(value="bigint") long right) {
        return left ^ right;
    }
}

