/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.annotations.OperatorDependency;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.operator.scalar.annotations.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.util.ArrayList;
import java.util.Iterator;

@ScalarFunction(value="array_remove")
@Description(value="Remove specified values from the given array")
public final class ArrayRemoveFunction {
    private ArrayRemoveFunction() {
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block remove(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") long value) {
        return ArrayRemoveFunction.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block remove(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") double value) {
        return ArrayRemoveFunction.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block remove(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") boolean value) {
        return ArrayRemoveFunction.remove(equalsFunction, type, array, (Object)value);
    }

    @TypeParameter(value="E")
    @SqlType(value="array(E)")
    public static Block remove(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"E", "E"}) MethodHandle equalsFunction, @TypeParameter(value="E") Type type, @SqlType(value="array(E)") Block array, @SqlType(value="E") Object value) {
        int sizeAfterRemove = 0;
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (int i = 0; i < array.getPositionCount(); ++i) {
            Object element = TypeUtils.readNativeValue((Type)type, (Block)array, (int)i);
            try {
                if (element != null && equalsFunction.invoke(element, value)) continue;
                positions.add(i);
                sizeAfterRemove += array.getLength(i);
                continue;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (array.getPositionCount() == positions.size()) {
            return array;
        }
        int entrySize = 0;
        if (!positions.isEmpty()) {
            entrySize = (int)Math.ceil((double)sizeAfterRemove / (double)positions.size());
        }
        BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), positions.size(), entrySize);
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            int position = (Integer)iterator.next();
            type.appendTo(array, position, blockBuilder);
        }
        return blockBuilder.build();
    }
}

