/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.annotations.OperatorDependency;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.operator.scalar.annotations.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;

@Description(value="Returns the position of the first occurrence of the given value in array (or 0 if not found)")
@ScalarFunction(value="array_position")
public final class ArrayPositionFunction {
    private ArrayPositionFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") boolean element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            boolean arrayValue = type.getBoolean(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") long element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            long arrayValue = type.getLong(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") double element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            double arrayValue = type.getDouble(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") Slice element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            Slice arrayValue = type.getSlice(array, i);
            try {
                if (!equalMethodHandle.invokeExact(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return 0L;
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long arrayPosition(@TypeParameter(value="T") Type type, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equalMethodHandle, @SqlType(value="array(T)") Block array, @SqlType(value="T") Block element) {
        int size = array.getPositionCount();
        for (int i = 0; i < size; ++i) {
            if (array.isNull(i)) continue;
            Object arrayValue = type.getObject(array, i);
            try {
                if (!equalMethodHandle.invoke(arrayValue, element)) continue;
                return i + 1;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return 0L;
    }

    @SqlType(value="bigint")
    @Nullable
    public static Long arrayPosition(@SqlType(value="array(unknown)") Block array, @Nullable @SqlType(value="unknown") Void element) {
        return null;
    }
}

