/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.ArrayMinMaxUtils;
import com.facebook.presto.operator.scalar.annotations.OperatorDependency;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.operator.scalar.annotations.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;

@ScalarFunction(value="array_min")
@Description(value="Get minimum value of array")
public final class ArrayMinFunction {
    private ArrayMinFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @Nullable
    public static Void arrayWithUnknownType(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @SqlType(value="array(T)") Block block) {
        return null;
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @Nullable
    public static Long longArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.longArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @Nullable
    public static Boolean booleanArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.booleanArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @Nullable
    public static Double doubleArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.doubleArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @Nullable
    public static Slice sliceArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        return ArrayMinMaxUtils.sliceArrayMinMax(compareMethodHandle, elementType, block);
    }

    @TypeParameter(value="T")
    @SqlType(value="T")
    @Nullable
    public static Block blockArrayMin(@OperatorDependency(operator=OperatorType.LESS_THAN, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle compareMethodHandle, @TypeParameter(value="T") Type elementType, @SqlType(value="array(T)") Block block) {
        try {
            if (block.getPositionCount() == 0) {
                return null;
            }
            Block selectedValue = (Block)elementType.getObject(block, 0);
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (block.isNull(i)) {
                    return null;
                }
                Block value = (Block)elementType.getObject(block, i);
                if (!compareMethodHandle.invokeExact(value, selectedValue)) continue;
                selectedValue = value;
            }
            return selectedValue;
        }
        catch (Throwable t) {
            Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
            Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
        }
    }
}

