/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.scalar.CombineHashFunction;
import com.facebook.presto.operator.scalar.annotations.OperatorDependency;
import com.facebook.presto.operator.scalar.annotations.ScalarOperator;
import com.facebook.presto.operator.scalar.annotations.TypeParameter;
import com.facebook.presto.operator.scalar.annotations.TypeParameterSpecialization;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.HASH_CODE)
public final class ArrayHashCodeOperator {
    private ArrayHashCodeOperator() {
    }

    @TypeParameter(value="T")
    @SqlType(value="bigint")
    public static long hash(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        int hash = 0;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(block.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            try {
                hash = (int)CombineHashFunction.getHash(hash, hashFunction.invoke(TypeUtils.readNativeValue((Type)type, (Block)block, (int)i)));
                continue;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return hash;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlType(value="bigint")
    public static long hashLong(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        int hash = 0;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(block.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            try {
                hash = (int)CombineHashFunction.getHash(hash, hashFunction.invokeExact(type.getLong(block, i)));
                continue;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return hash;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlType(value="bigint")
    public static long hashBoolean(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        int hash = 0;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(block.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            try {
                hash = (int)CombineHashFunction.getHash(hash, hashFunction.invokeExact(type.getBoolean(block, i)));
                continue;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return hash;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlType(value="bigint")
    public static long hashSlice(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        int hash = 0;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(block.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            try {
                hash = (int)CombineHashFunction.getHash(hash, hashFunction.invokeExact(type.getSlice(block, i)));
                continue;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return hash;
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlType(value="bigint")
    public static long hashDouble(@OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"T"}) MethodHandle hashFunction, @TypeParameter(value="T") Type type, @SqlType(value="array(T)") Block block) {
        int hash = 0;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            com.facebook.presto.type.TypeUtils.checkElementNotNull(block.isNull(i), "ARRAY comparison not supported for arrays with null elements");
            try {
                hash = (int)CombineHashFunction.getHash(hash, hashFunction.invokeExact(type.getDouble(block, i)));
                continue;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        return hash;
    }
}

