/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.OperatorType;
import com.facebook.presto.operator.Description;
import com.facebook.presto.operator.scalar.annotations.OperatorDependency;
import com.facebook.presto.operator.scalar.annotations.ScalarFunction;
import com.facebook.presto.operator.scalar.annotations.TypeParameter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.SqlType;
import com.google.common.base.Throwables;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import javax.annotation.Nullable;

@Description(value="Determines whether given value exists in the array")
@ScalarFunction(value="contains")
public final class ArrayContains {
    private ArrayContains() {
    }

    @SqlType(value="boolean")
    @Nullable
    public static Boolean arrayWithUnknownType(@SqlType(value="array(unknown)") Block arrayBlock, @Nullable @SqlType(value="unknown") Void value) {
        return null;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @Nullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") Block value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                if (!equals.invokeExact((Block)elementType.getObject(arrayBlock, i), value)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @Nullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") Slice value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                if (!equals.invokeExact(elementType.getSlice(arrayBlock, i), value)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @Nullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") long value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                if (!equals.invokeExact(elementType.getLong(arrayBlock, i), value)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @Nullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") boolean value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                if (!equals.invokeExact(elementType.getBoolean(arrayBlock, i), value)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @Nullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") double value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                if (!equals.invokeExact(elementType.getDouble(arrayBlock, i), value)) continue;
                return true;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t, Error.class);
                Throwables.propagateIfInstanceOf((Throwable)t, PrestoException.class);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }
}

