/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.type.TypeUtils;
import com.facebook.presto.util.array.IntBigArray;
import com.google.common.base.Preconditions;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class TypedSet {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(TypedSet.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    private static final long FOUR_MEGABYTES = new DataSize(4.0, DataSize.Unit.MEGABYTE).toBytes();
    private final Type elementType;
    private final IntBigArray blockPositionByHash = new IntBigArray();
    private final BlockBuilder elementBlock;
    private int maxFill;
    private int hashMask;
    private static final int EMPTY_SLOT = -1;
    private boolean containsNullElement;

    public TypedSet(Type elementType, int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (Object)"expectedSize must not be negative");
        this.elementType = Objects.requireNonNull(elementType, "elementType must not be null");
        this.elementBlock = elementType.createBlockBuilder(new BlockBuilderStatus(), expectedSize);
        int hashSize = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = TypedSet.calculateMaxFill(hashSize);
        this.hashMask = hashSize - 1;
        this.blockPositionByHash.ensureCapacity(hashSize);
        for (int i = 0; i < hashSize; ++i) {
            this.blockPositionByHash.set(i, -1);
        }
        this.containsNullElement = false;
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + this.elementBlock.getRetainedSizeInBytes()) + this.blockPositionByHash.sizeOf();
    }

    public boolean contains(Block block, int position) {
        Objects.requireNonNull(block, "block must not be null");
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
        if (block.isNull(position)) {
            return this.containsNullElement;
        }
        return this.blockPositionByHash.get(this.getHashPositionOfElement(block, position)) != -1;
    }

    public void add(Block block, int position) {
        Objects.requireNonNull(block, "block must not be null");
        Preconditions.checkArgument((position >= 0 ? 1 : 0) != 0, (Object)"position must be >= 0");
        if (block.isNull(position)) {
            this.containsNullElement = true;
        } else {
            long hashPosition = this.getHashPositionOfElement(block, position);
            if (this.blockPositionByHash.get(hashPosition) == -1) {
                this.addNewElement(hashPosition, block, position);
            }
        }
    }

    public int size() {
        return this.elementBlock.getPositionCount() + (this.containsNullElement ? 1 : 0);
    }

    public int positionOf(Block block, int position) {
        return this.blockPositionByHash.get(this.getHashPositionOfElement(block, position));
    }

    private long getHashPositionOfElement(Block block, int position) {
        long hashPosition = this.getMaskedHash(TypeUtils.hashPosition(this.elementType, block, position));
        int blockPosition;
        while ((blockPosition = this.blockPositionByHash.get(hashPosition)) != -1) {
            if (TypeUtils.positionEqualsPosition(this.elementType, (Block)this.elementBlock, blockPosition, block, position)) {
                return hashPosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1L);
        }
        return hashPosition;
    }

    private void addNewElement(long hashPosition, Block block, int position) {
        this.elementType.appendTo(block, position, this.elementBlock);
        if ((long)this.elementBlock.getSizeInBytes() > FOUR_MEGABYTES) {
            throw ExceededMemoryLimitException.exceededLocalLimit(new DataSize(4.0, DataSize.Unit.MEGABYTE));
        }
        this.blockPositionByHash.set(hashPosition, this.elementBlock.getPositionCount() - 1);
        if (this.elementBlock.getPositionCount() >= this.maxFill) {
            this.rehash(this.maxFill * 2);
        }
    }

    private void rehash(int size) {
        int newHashSize = HashCommon.arraySize((int)(size + 1), (float)0.75f);
        this.hashMask = newHashSize - 1;
        this.maxFill = TypedSet.calculateMaxFill(newHashSize);
        this.blockPositionByHash.ensureCapacity(newHashSize);
        for (int i = 0; i < newHashSize; ++i) {
            this.blockPositionByHash.set(i, -1);
        }
        this.rehashBlock((Block)this.elementBlock);
    }

    private void rehashBlock(Block block) {
        for (int blockPosition = 0; blockPosition < block.getPositionCount(); ++blockPosition) {
            this.blockPositionByHash.set(this.getHashPositionOfElement(block, blockPosition), blockPosition);
        }
    }

    private static int calculateMaxFill(int hashSize) {
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        return maxFill;
    }

    private long getMaskedHash(long rawHash) {
        return rawHash & (long)this.hashMask;
    }
}

