/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.IntermediateInputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.NullableDoubleState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.testing.AggregationTestUtils;
import com.facebook.presto.type.SqlType;

@AggregationFunction(value="sum")
public final class DoubleSumAggregation {
    public static final InternalAggregationFunction DOUBLE_SUM = AggregationTestUtils.generateInternalAggregationFunction(DoubleSumAggregation.class);

    private DoubleSumAggregation() {
    }

    @InputFunction
    @IntermediateInputFunction
    public static void sum(NullableDoubleState state, @SqlType(value="double") double value) {
        state.setNull(false);
        state.setDouble(state.getDouble() + value);
    }

    @OutputFunction(value="double")
    public static void output(NullableDoubleState state, BlockBuilder out) {
        NullableDoubleState.write((Type)DoubleType.DOUBLE, state, out);
    }
}

