/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.LongState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.testing.AggregationTestUtils;

@AggregationFunction(value="count")
public final class CountAggregation {
    public static final InternalAggregationFunction COUNT = AggregationTestUtils.generateInternalAggregationFunction(CountAggregation.class);

    private CountAggregation() {
    }

    @InputFunction
    public static void input(LongState state) {
        state.setLong(state.getLong() + 1L);
    }

    @CombineFunction
    public static void combine(LongState state, LongState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
    }

    @OutputFunction(value="bigint")
    public static void output(LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getLong());
    }
}

