/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.state.LongAndDoubleState;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.testing.AggregationTestUtils;
import com.facebook.presto.type.SqlType;
import com.google.common.collect.ImmutableList;
import java.util.List;

@AggregationFunction(value="avg")
public final class AverageAggregations {
    public static final InternalAggregationFunction LONG_AVERAGE = AggregationTestUtils.generateInternalAggregationFunction(AverageAggregations.class, DoubleType.DOUBLE.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature()));
    public static final InternalAggregationFunction DOUBLE_AVERAGE = AggregationTestUtils.generateInternalAggregationFunction(AverageAggregations.class, DoubleType.DOUBLE.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)DoubleType.DOUBLE.getTypeSignature()));

    private AverageAggregations() {
    }

    @InputFunction
    public static void input(LongAndDoubleState state, @SqlType(value="bigint") long value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + (double)value);
    }

    @InputFunction
    public static void input(LongAndDoubleState state, @SqlType(value="double") double value) {
        state.setLong(state.getLong() + 1L);
        state.setDouble(state.getDouble() + value);
    }

    @CombineFunction
    public static void combine(LongAndDoubleState state, LongAndDoubleState otherState) {
        state.setLong(state.getLong() + otherState.getLong());
        state.setDouble(state.getDouble() + otherState.getDouble());
    }

    @OutputFunction(value="double")
    public static void output(LongAndDoubleState state, BlockBuilder out) {
        long count = state.getLong();
        if (count == 0L) {
            out.appendNull();
        } else {
            double value = state.getDouble();
            DoubleType.DOUBLE.writeDouble(out, value / (double)count);
        }
    }
}

