/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AggregationFunction;
import com.facebook.presto.operator.aggregation.ApproximateUtils;
import com.facebook.presto.operator.aggregation.BlockIndex;
import com.facebook.presto.operator.aggregation.BlockPosition;
import com.facebook.presto.operator.aggregation.CombineFunction;
import com.facebook.presto.operator.aggregation.InputFunction;
import com.facebook.presto.operator.aggregation.OutputFunction;
import com.facebook.presto.operator.aggregation.SampleWeight;
import com.facebook.presto.operator.aggregation.state.AccumulatorState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.LiteralParameters;
import com.facebook.presto.type.SqlType;
import io.airlift.slice.Slices;

@AggregationFunction(value="count", approximate=true)
public final class ApproximateCountColumnAggregations {
    private static final int OUTPUT_VARCHAR_TYPE = 57;

    private ApproximateCountColumnAggregations() {
    }

    @InputFunction
    public static void booleanInput(ApproximateCountState state, @BlockPosition @SqlType(value="boolean") Block block, @BlockIndex int index, @SampleWeight long sampleWeight) {
        state.setCount(state.getCount() + sampleWeight);
        state.setSamples(state.getSamples() + 1L);
    }

    @InputFunction
    public static void bigintInput(ApproximateCountState state, @BlockPosition @SqlType(value="bigint") Block block, @BlockIndex int index, @SampleWeight long sampleWeight) {
        state.setCount(state.getCount() + sampleWeight);
        state.setSamples(state.getSamples() + 1L);
    }

    @InputFunction
    public static void doubleInput(ApproximateCountState state, @BlockPosition @SqlType(value="double") Block block, @BlockIndex int index, @SampleWeight long sampleWeight) {
        state.setCount(state.getCount() + sampleWeight);
        state.setSamples(state.getSamples() + 1L);
    }

    @InputFunction
    @LiteralParameters(value={"x"})
    public static void varcharInput(ApproximateCountState state, @BlockPosition @SqlType(value="varchar(x)") Block block, @BlockIndex int index, @SampleWeight long sampleWeight) {
        state.setCount(state.getCount() + sampleWeight);
        state.setSamples(state.getSamples() + 1L);
    }

    @CombineFunction
    public static void combine(ApproximateCountState state, ApproximateCountState otherState) {
        state.setCount(state.getCount() + otherState.getCount());
        state.setSamples(state.getSamples() + otherState.getSamples());
    }

    @OutputFunction(value="varchar(57)")
    public static void output(ApproximateCountState state, double confidence, BlockBuilder out) {
        String result = ApproximateUtils.formatApproximateResult(state.getCount(), ApproximateUtils.countError(state.getSamples(), state.getCount()), confidence, true);
        VarcharType.createVarcharType((int)57).writeSlice(out, Slices.utf8Slice((String)result));
    }

    public static interface ApproximateCountState
    extends AccumulatorState {
        public long getCount();

        public void setCount(long var1);

        public long getSamples();

        public void setSamples(long var1);
    }
}

