/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.SharedBuffer;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OutputFactory;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class TaskOutputOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final SharedBuffer sharedBuffer;
    private final Function<Page, Page> pagePreprocessor;
    private ListenableFuture<?> blocked = NOT_BLOCKED;
    private boolean finished;

    public TaskOutputOperator(OperatorContext operatorContext, SharedBuffer sharedBuffer, Function<Page, Page> pagePreprocessor) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sharedBuffer = Objects.requireNonNull(sharedBuffer, "sharedBuffer is null");
        this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public List<Type> getTypes() {
        return ImmutableList.of();
    }

    @Override
    public void finish() {
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return this.finished && this.blocked == NOT_BLOCKED;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        if (this.blocked != NOT_BLOCKED && this.blocked.isDone()) {
            this.blocked = NOT_BLOCKED;
        }
        return !this.finished && this.blocked == NOT_BLOCKED;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        if (page.getPositionCount() == 0) {
            return;
        }
        Preconditions.checkState((this.blocked == NOT_BLOCKED ? 1 : 0) != 0, (Object)"output is already blocked");
        page = this.pagePreprocessor.apply(page);
        ListenableFuture<?> future = this.sharedBuffer.enqueue(page);
        if (!future.isDone()) {
            this.blocked = future;
        }
        this.operatorContext.recordGeneratedOutput(page.getSizeInBytes(), page.getPositionCount());
    }

    @Override
    public Page getOutput() {
        return null;
    }

    public static class TaskOutputOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final SharedBuffer sharedBuffer;
        private final Function<Page, Page> pagePreprocessor;

        public TaskOutputOperatorFactory(int operatorId, PlanNodeId planNodeId, SharedBuffer sharedBuffer, Function<Page, Page> pagePreprocessor) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.sharedBuffer = Objects.requireNonNull(sharedBuffer, "sharedBuffer is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        }

        @Override
        public List<Type> getTypes() {
            return ImmutableList.of();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TaskOutputOperator.class.getSimpleName());
            return new TaskOutputOperator(operatorContext, this.sharedBuffer, this.pagePreprocessor);
        }

        @Override
        public void close() {
        }

        @Override
        public OperatorFactory duplicate() {
            return new TaskOutputOperatorFactory(this.operatorId, this.planNodeId, this.sharedBuffer, this.pagePreprocessor);
        }
    }

    public static class TaskOutputFactory
    implements OutputFactory {
        private final SharedBuffer sharedBuffer;

        public TaskOutputFactory(SharedBuffer sharedBuffer) {
            this.sharedBuffer = Objects.requireNonNull(sharedBuffer, "sharedBuffer is null");
        }

        @Override
        public OperatorFactory createOutputOperator(int operatorId, PlanNodeId planNodeId, List<Type> types, Function<Page, Page> pagePreprocessor) {
            return new TaskOutputOperatorFactory(operatorId, planNodeId, this.sharedBuffer, pagePreprocessor);
        }
    }
}

