/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.SystemMemoryUsageListener;
import com.facebook.presto.memory.LocalMemoryContext;
import com.facebook.presto.operator.OperatorContext;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class SystemMemoryUsageTracker
implements SystemMemoryUsageListener {
    private final LocalMemoryContext memoryContext;
    private long bytes;

    public SystemMemoryUsageTracker(OperatorContext operatorContext) {
        this.memoryContext = Objects.requireNonNull(operatorContext, "operatorContext is null").getSystemMemoryContext().newLocalMemoryContext();
    }

    @Override
    public void updateSystemMemoryUsage(long deltaMemoryInBytes) {
        Preconditions.checkArgument((this.bytes + deltaMemoryInBytes >= 0L ? 1 : 0) != 0, (Object)"tried to free more memory than is reserved");
        this.bytes += deltaMemoryInBytes;
        this.memoryContext.setBytes(this.bytes);
    }
}

